/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.ios;

import com.google.common.collect.ImmutableMap;
import io.appium.java_client.ExecutesMethod;
import io.appium.java_client.ws.StringWebSocketClient;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import org.openqa.selenium.remote.RemoteWebDriver;

public interface ListensToSyslogMessages
extends ExecutesMethod {
    public static final StringWebSocketClient syslogClient = new StringWebSocketClient();

    default public void startSyslogBroadcast() {
        this.startSyslogBroadcast("localhost", 4723);
    }

    default public void startSyslogBroadcast(String host) {
        this.startSyslogBroadcast(host, 4723);
    }

    default public void startSyslogBroadcast(String host, int port) {
        URI endpointUri;
        this.execute("executeScript", (Map<String, ?>)ImmutableMap.of((Object)"script", (Object)"mobile: startLogsBroadcast", (Object)"args", Collections.emptyList()));
        try {
            endpointUri = new URI(String.format("ws://%s:%s/ws/session/%s/appium/device/syslog", host, port, ((RemoteWebDriver)this).getSessionId()));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        syslogClient.connect(endpointUri);
    }

    default public void addSyslogMessagesListener(Consumer<String> handler) {
        syslogClient.addMessageHandler(handler);
    }

    default public void addSyslogErrorsListener(Consumer<Throwable> handler) {
        syslogClient.addErrorHandler(handler);
    }

    default public void addSyslogConnectionListener(Runnable handler) {
        syslogClient.addConnectionHandler(handler);
    }

    default public void addSyslogDisconnectionListener(Runnable handler) {
        syslogClient.addDisconnectionHandler(handler);
    }

    default public void removeAllSyslogListeners() {
        syslogClient.removeAllHandlers();
    }

    default public void stopSyslogBroadcast() {
        this.execute("executeScript", (Map<String, ?>)ImmutableMap.of((Object)"script", (Object)"mobile: stopLogsBroadcast", (Object)"args", Collections.emptyList()));
    }
}

