/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import nu.pattern.OpenCV;
import org.opencv.core.Core;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;

public class ScreenshotState {
    private static final Duration DEFAULT_INTERVAL_MS = Duration.ofMillis(500L);
    private Optional<BufferedImage> previousScreenshot = Optional.empty();
    private Supplier<BufferedImage> stateProvider;
    private Duration comparisonInterval = DEFAULT_INTERVAL_MS;

    static {
        OpenCV.loadShared();
    }

    public ScreenshotState(Supplier<BufferedImage> stateProvider) {
        this.stateProvider = stateProvider;
    }

    public Duration getComparisonInterval() {
        return this.comparisonInterval;
    }

    public ScreenshotState setComparisonInterval(Duration comparisonInterval) {
        this.comparisonInterval = comparisonInterval;
        return this;
    }

    public ScreenshotState remember() {
        this.previousScreenshot = Optional.of(this.stateProvider.get());
        return this;
    }

    public ScreenshotState remember(BufferedImage customInitialState) {
        this.previousScreenshot = Optional.of(customInitialState);
        return this;
    }

    private ScreenshotState checkState(Function<Double, Boolean> checkerFunc, Duration timeout) {
        return this.checkState(checkerFunc, timeout, ResizeMode.NO_RESIZE);
    }

    private ScreenshotState checkState(Function<Double, Boolean> checkerFunc, Duration timeout, ResizeMode resizeMode) {
        double score;
        LocalDateTime started = LocalDateTime.now();
        do {
            BufferedImage currentState = this.stateProvider.get();
            score = ScreenshotState.getOverlapScore(this.previousScreenshot.orElseThrow(() -> new ScreenshotComparisonError("Initial screenshot state is not set. Nothing to compare")), currentState, resizeMode);
            if (checkerFunc.apply(score).booleanValue()) {
                return this;
            }
            try {
                Thread.sleep(this.comparisonInterval.toMillis());
            }
            catch (InterruptedException e) {
                throw new ScreenshotComparisonError(e);
            }
        } while (Duration.between(started, LocalDateTime.now()).compareTo(timeout) <= 0);
        throw new ScreenshotComparisonTimeout(String.format("Screenshot comparison timed out after %s ms. Actual similarity score: %.5f", timeout.toMillis(), score), score);
    }

    public ScreenshotState verifyChanged(Duration timeout, double minScore) {
        return this.checkState(x -> x < minScore, timeout);
    }

    public ScreenshotState verifyChanged(Duration timeout, double minScore, ResizeMode resizeMode) {
        return this.checkState(x -> x < minScore, timeout, resizeMode);
    }

    public ScreenshotState verifyNotChanged(Duration timeout, double minScore) {
        return this.checkState(x -> x >= minScore, timeout);
    }

    public ScreenshotState verifyNotChanged(Duration timeout, double minScore, ResizeMode resizeMode) {
        return this.checkState(x -> x >= minScore, timeout, resizeMode);
    }

    private static Mat prepareImageForComparison(BufferedImage srcImage) {
        BufferedImage normalizedBitmap = new BufferedImage(srcImage.getWidth(), srcImage.getHeight(), 5);
        Graphics2D g = normalizedBitmap.createGraphics();
        try {
            g.setComposite(AlphaComposite.Src);
            g.drawImage((Image)srcImage, 0, 0, null);
        }
        finally {
            g.dispose();
        }
        byte[] pixels = ((DataBufferByte)normalizedBitmap.getRaster().getDataBuffer()).getData();
        Mat result = new Mat(normalizedBitmap.getHeight(), normalizedBitmap.getWidth(), CvType.CV_8UC3);
        result.put(0, 0, pixels);
        return result;
    }

    private static Mat resizeFirstMatrixToSecondMatrixResolution(Mat first, Mat second) {
        if (first.width() != second.width() || first.height() != second.height()) {
            Mat result = new Mat();
            Size sz = new Size((double)second.width(), (double)second.height());
            Imgproc.resize((Mat)first, (Mat)result, (Size)sz);
            return result;
        }
        return first;
    }

    public static double getOverlapScore(BufferedImage refImage, BufferedImage tplImage) {
        return ScreenshotState.getOverlapScore(refImage, tplImage, ResizeMode.NO_RESIZE);
    }

    public static double getOverlapScore(BufferedImage refImage, BufferedImage tplImage, ResizeMode resizeMode) {
        Mat ref = ScreenshotState.prepareImageForComparison(refImage);
        if (ref.empty()) {
            throw new ScreenshotComparisonError("Reference image cannot be converted for further comparison");
        }
        Mat tpl = ScreenshotState.prepareImageForComparison(tplImage);
        if (tpl.empty()) {
            throw new ScreenshotComparisonError("Template image cannot be converted for further comparison");
        }
        switch (resizeMode) {
            case TEMPLATE_TO_REFERENCE_RESOLUTION: {
                tpl = ScreenshotState.resizeFirstMatrixToSecondMatrixResolution(tpl, ref);
                break;
            }
            case REFERENCE_TO_TEMPLATE_RESOLUTION: {
                ref = ScreenshotState.resizeFirstMatrixToSecondMatrixResolution(ref, tpl);
            }
        }
        if (ref.width() != tpl.width() || ref.height() != tpl.height()) {
            throw new ScreenshotComparisonError("Resolutions of template and reference images are expected to be equal. Try different resizeMode value.");
        }
        Mat res = new Mat(ref.rows() - tpl.rows() + 1, ref.cols() - tpl.cols() + 1, CvType.CV_32FC1);
        Imgproc.matchTemplate((Mat)ref, (Mat)tpl, (Mat)res, (int)5);
        return Core.minMaxLoc((Mat)res).maxVal;
    }

    public static enum ResizeMode {
        NO_RESIZE,
        TEMPLATE_TO_REFERENCE_RESOLUTION,
        REFERENCE_TO_TEMPLATE_RESOLUTION;

    }

    public static class ScreenshotComparisonError
    extends RuntimeException {
        private static final long serialVersionUID = -7011854909939194466L;

        ScreenshotComparisonError(Throwable reason) {
            super(reason);
        }

        ScreenshotComparisonError(String message) {
            super(message);
        }
    }

    public static class ScreenshotComparisonTimeout
    extends RuntimeException {
        private static final long serialVersionUID = 6336247721154252476L;
        private double currentScore = Double.NaN;

        ScreenshotComparisonTimeout(String message, double currentScore) {
            super(message);
            this.currentScore = currentScore;
        }

        public double getCurrentScore() {
            return this.currentScore;
        }
    }
}

