/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.remote;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.net.MediaType;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.BeanToJsonConverter;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.Dialect;
import org.openqa.selenium.remote.ErrorHandler;
import org.openqa.selenium.remote.JsonException;
import org.openqa.selenium.remote.JsonToBeanConverter;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

class AppiumProtocolHandShake {
    AppiumProtocolHandShake() {
    }

    public Result createSession(HttpClient client, Command command) throws IOException, WebDriverException {
        Capabilities desired = Optional.ofNullable((Capabilities)command.getParameters().get("desiredCapabilities")).orElseGet(DesiredCapabilities::new);
        Capabilities required = Optional.ofNullable((Capabilities)command.getParameters().get("requiredCapabilities")).orElseGet(DesiredCapabilities::new);
        JsonParser parser = new JsonParser();
        JsonElement des = parser.parse(new BeanToJsonConverter().convert((Object)desired));
        JsonElement req = parser.parse(new BeanToJsonConverter().convert((Object)required));
        JsonObject jsonObject = new JsonObject();
        this.amendW3CParameters(jsonObject, des, req);
        this.amendOssParamters(jsonObject, des, req);
        Optional<Result> result = this.createSession(client, jsonObject);
        return Optional.ofNullable(result.orElseGet(() -> {
            JsonObject jsonObject1 = new JsonObject();
            this.amendOssParamters(jsonObject1, des, req);
            try {
                return this.createSession(client, jsonObject1).orElseGet(() -> {
                    JsonObject jsonObject2 = new JsonObject();
                    this.amendW3CParameters(jsonObject2, des, req);
                    try {
                        return this.createSession(client, jsonObject2).orElse(null);
                    }
                    catch (IOException e) {
                        throw new WebDriverException((Throwable)e);
                    }
                });
            }
            catch (IOException e) {
                throw new WebDriverException((Throwable)e);
            }
        })).orElseThrow(() -> new SessionNotCreatedException(String.format("Unable to create new remote session. desired capabilities = %s, required capabilities = %s", desired, required)));
    }

    private Optional<Result> createSession(HttpClient client, JsonObject params) throws IOException {
        HttpRequest request = new HttpRequest(HttpMethod.POST, "/session");
        String content = params.toString();
        byte[] data = content.getBytes(Charsets.UTF_8);
        request.setHeader("Content-Length", String.valueOf(data.length));
        request.setHeader("Content-Type", MediaType.JSON_UTF_8.toString());
        request.setContent(data);
        HttpResponse response = client.execute(request, true);
        Map jsonBlob = new HashMap();
        String resultString = response.getContentString();
        try {
            jsonBlob = (Map)new JsonToBeanConverter().convert(Map.class, (Object)resultString);
        }
        catch (ClassCastException classCastException) {
            return Optional.empty();
        }
        catch (JsonException jsonException) {}
        Object sessionId = jsonBlob.get("sessionId");
        Object value = jsonBlob.get("value");
        Object w3cError = jsonBlob.get("error");
        Object ossStatus = jsonBlob.get("status");
        Map capabilities = null;
        if (value != null && value instanceof Map) {
            capabilities = (Map)value;
        } else if (value != null && value instanceof Capabilities) {
            capabilities = ((Capabilities)capabilities).asMap();
        }
        if (response.getStatus() == 200 && sessionId != null && capabilities != null) {
            Dialect dialect = ossStatus == null ? Dialect.W3C : Dialect.OSS;
            return Optional.of(new Result(dialect, String.valueOf(sessionId), capabilities));
        }
        Response tempResponse = null;
        if ("session not created".equals(w3cError)) {
            tempResponse = new Response(null);
            tempResponse.setStatus(Integer.valueOf(33));
            tempResponse.setValue(jsonBlob);
        } else if (ossStatus instanceof Number && ((Number)ossStatus).intValue() == 33) {
            tempResponse = new Response(null);
            tempResponse.setStatus(Integer.valueOf(33));
            tempResponse.setValue(jsonBlob);
        }
        if (tempResponse != null) {
            new ErrorHandler().throwIfResponseFailed(tempResponse, 0L);
        }
        return Optional.empty();
    }

    private void amendW3CParameters(JsonObject jsonObject, JsonElement desired, JsonElement required) {
        JsonArray result = new JsonArray();
        JsonObject desiredJson = new JsonObject();
        JsonObject requiredJson = new JsonObject();
        desiredJson.add("desiredCapabilities", desired);
        requiredJson.add("requiredCapabilities", required);
        result.add((JsonElement)desiredJson);
        result.add((JsonElement)requiredJson);
        jsonObject.add("capabilities", (JsonElement)result);
    }

    private void amendOssParamters(JsonObject jsonObject, JsonElement desired, JsonElement required) {
        jsonObject.add("desiredCapabilities", desired);
        jsonObject.add("requiredCapabilities", required);
    }

    public class Result {
        private final Dialect dialect;
        private final Map<String, ?> capabilities;
        private final SessionId sessionId;

        private Result(Dialect dialect, String sessionId, Map<String, ?> capabilities) {
            this.dialect = dialect;
            this.sessionId = new SessionId((String)Preconditions.checkNotNull((Object)sessionId));
            this.capabilities = capabilities;
        }

        public Dialect getDialect() {
            return this.dialect;
        }

        public Response createResponse() {
            Response response = new Response(this.sessionId);
            response.setValue(this.capabilities);
            response.setStatus(Integer.valueOf(0));
            return response;
        }

        public String toString() {
            return String.format("%s: %s", this.dialect, this.capabilities);
        }
    }
}

