/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client;

import io.appium.java_client.AppiumDriver;
import io.appium.java_client.FindsByAccessibilityId;
import io.appium.java_client.IllegalCoordinatesException;
import io.appium.java_client.SwipeElementDirection;
import io.appium.java_client.TouchableElement;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.RemoteWebElement;

public abstract class MobileElement
extends RemoteWebElement
implements FindsByAccessibilityId,
TouchableElement {
    protected FileDetector fileDetector;

    public List<WebElement> findElements(By by) {
        return by.findElements((SearchContext)this);
    }

    public WebElement findElement(By by) {
        return by.findElement((SearchContext)this);
    }

    @Override
    public WebElement findElementByAccessibilityId(String using) {
        return this.findElement("accessibility id", using);
    }

    @Override
    public List<WebElement> findElementsByAccessibilityId(String using) {
        return this.findElements("accessibility id", using);
    }

    public Point getCenter() {
        Point upperLeft = this.getLocation();
        Dimension dimensions = this.getSize();
        return new Point(upperLeft.getX() + dimensions.getWidth() / 2, upperLeft.getY() + dimensions.getHeight() / 2);
    }

    @Override
    public void pinch() {
        ((AppiumDriver)this.parent).pinch(this);
    }

    @Override
    public void tap(int fingers, int duration) {
        ((AppiumDriver)this.parent).tap(fingers, this, duration);
    }

    @Override
    public void zoom() {
        ((AppiumDriver)this.parent).zoom(this);
    }

    @Override
    public void swipe(SwipeElementDirection direction, int duration) {
        direction.swipe((AppiumDriver)this.parent, this, 0, 0, duration);
    }

    @Override
    public void swipe(SwipeElementDirection direction, int offsetFromStartBorder, int offsetFromEndBorder, int duration) throws IllegalCoordinatesException {
        direction.swipe((AppiumDriver)this.parent, this, offsetFromStartBorder, offsetFromEndBorder, duration);
    }
}

