/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client;

import com.google.common.collect.ImmutableMap;
import io.appium.java_client.FindsByAccessibilityId;
import io.appium.java_client.FindsByAndroidUIAutomator;
import io.appium.java_client.FindsByIosUIAutomation;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.RemoteWebElement;

public class MobileElement
extends RemoteWebElement
implements FindsByAccessibilityId,
FindsByAndroidUIAutomator,
FindsByIosUIAutomation {
    protected FileDetector fileDetector;

    public List<WebElement> findElements(By by) {
        return by.findElements((SearchContext)this);
    }

    public WebElement findElement(By by) {
        return by.findElement((SearchContext)this);
    }

    @Override
    public WebElement findElementByIosUIAutomation(String using) {
        return this.findElement("-ios uiautomation", using);
    }

    @Override
    public List<WebElement> findElementsByIosUIAutomation(String using) {
        return this.findElements("-ios uiautomation", using);
    }

    @Override
    public WebElement findElementByAndroidUIAutomator(String using) {
        return this.findElement("-android uiautomator", using);
    }

    @Override
    public List<WebElement> findElementsByAndroidUIAutomator(String using) {
        return this.findElements("-android uiautomator", using);
    }

    @Override
    public WebElement findElementByAccessibilityId(String using) {
        return this.findElement("accessibility id", using);
    }

    @Override
    public List<WebElement> findElementsByAccessibilityId(String using) {
        return this.findElements("accessibility id", using);
    }

    public void setValue(String value) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"id", (Object)this.id).put((Object)"value", (Object)value);
        this.execute("setValue", (Map)builder.build());
    }

    public Point getCenter() {
        Point upperLeft = this.getLocation();
        Dimension dimensions = this.getSize();
        return new Point(upperLeft.getX() + dimensions.getWidth() / 2, upperLeft.getY() + dimensions.getHeight() / 2);
    }
}

