/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.bytecode.expression;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.bytecode.ArrayOpCode;
import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.MethodGenerationContext;
import io.airlift.bytecode.expression.BytecodeExpression;
import io.airlift.bytecode.instruction.InstructionNode;
import java.util.List;
import java.util.Objects;

class GetElementBytecodeExpression
extends BytecodeExpression {
    private final BytecodeExpression instance;
    private final BytecodeExpression index;
    private final InstructionNode arrayLoadInstruction;

    public GetElementBytecodeExpression(BytecodeExpression instance, BytecodeExpression index) {
        super(instance.getType().getArrayComponentType());
        this.instance = Objects.requireNonNull(instance, "instance is null");
        this.index = Objects.requireNonNull(index, "index is null");
        Preconditions.checkArgument((index.getType().getPrimitiveType() == Integer.TYPE ? 1 : 0) != 0, (Object)("index must be int type, but is " + index.getType()));
        this.arrayLoadInstruction = ArrayOpCode.getArrayOpCode(instance.getType().getArrayComponentType()).getLoad();
    }

    @Override
    public BytecodeNode getBytecode(MethodGenerationContext generationContext) {
        return new BytecodeBlock().append(this.instance.getBytecode(generationContext)).append(this.index).append(this.arrayLoadInstruction);
    }

    @Override
    protected String formatOneLine() {
        return this.instance + "[" + this.index + "]";
    }

    @Override
    public List<BytecodeNode> getChildNodes() {
        return ImmutableList.of((Object)this.index);
    }
}

