/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.bytecode;

import io.airlift.bytecode.ByteCodeGenerator;
import io.airlift.bytecode.ClassDefinition;
import io.airlift.bytecode.ClassInfoLoader;
import java.io.Writer;
import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import java.util.Optional;

public class HiddenClassGenerator {
    private final MethodHandles.Lookup lookup;
    private final ByteCodeGenerator byteCodeGenerator;

    public static HiddenClassGenerator hiddenClassGenerator(MethodHandles.Lookup lookup) {
        return new HiddenClassGenerator(lookup, ByteCodeGenerator.byteCodeGenerator());
    }

    private HiddenClassGenerator(MethodHandles.Lookup lookup, ByteCodeGenerator byteCodeGenerator) {
        this.lookup = lookup;
        this.byteCodeGenerator = byteCodeGenerator;
    }

    public HiddenClassGenerator fakeLineNumbers(boolean fakeLineNumbers) {
        return new HiddenClassGenerator(this.lookup, this.byteCodeGenerator.fakeLineNumbers(fakeLineNumbers));
    }

    public HiddenClassGenerator runAsmVerifier(boolean runAsmVerifier) {
        return new HiddenClassGenerator(this.lookup, this.byteCodeGenerator.runAsmVerifier(runAsmVerifier ? new LookupClassLoader(this.lookup) : null));
    }

    public HiddenClassGenerator dumpRawBytecode(boolean dumpRawBytecode) {
        return new HiddenClassGenerator(this.lookup, this.byteCodeGenerator.dumpRawBytecode(dumpRawBytecode));
    }

    public HiddenClassGenerator outputTo(Writer output) {
        return new HiddenClassGenerator(this.lookup, this.byteCodeGenerator.outputTo(output));
    }

    public HiddenClassGenerator dumpClassFilesTo(Path dumpClassPath) {
        return this.dumpClassFilesTo(Optional.of(dumpClassPath));
    }

    public HiddenClassGenerator dumpClassFilesTo(Optional<Path> dumpClassPath) {
        return new HiddenClassGenerator(this.lookup, this.byteCodeGenerator.dumpClassFilesTo(dumpClassPath));
    }

    public <T> Class<? extends T> defineHiddenClass(ClassDefinition classDefinition, Class<T> superType, Optional<Object> classData) {
        MethodHandles.Lookup definedClassLookup;
        ClassInfoLoader classInfoLoader = ClassInfoLoader.createClassInfoLoader(classDefinition, this.lookup);
        byte[] bytecode = this.byteCodeGenerator.generateByteCode(classInfoLoader, classDefinition);
        try {
            definedClassLookup = classData.isEmpty() ? this.lookup.defineHiddenClass(bytecode, true, new MethodHandles.Lookup.ClassOption[0]) : this.lookup.defineHiddenClassWithClassData(bytecode, classData.get(), true, new MethodHandles.Lookup.ClassOption[0]);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        return definedClassLookup.lookupClass().asSubclass(superType);
    }

    private static class LookupClassLoader
    extends ClassLoader {
        private final MethodHandles.Lookup lookup;

        public LookupClassLoader(MethodHandles.Lookup lookup) {
            this.lookup = lookup;
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            try {
                return this.lookup.findClass(name);
            }
            catch (IllegalAccessException e) {
                throw new ClassNotFoundException(name, e);
            }
        }
    }
}

