/*
 * Decompiled with CFR 0.152.
 */
package io.adamantic.quicknote;

import io.adamantic.quicknote.exceptions.ConfigException;
import io.github.cdimascio.dotenv.Dotenv;
import org.apache.commons.configuration2.BaseHierarchicalConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.YAMLConfiguration;
import org.apache.commons.configuration2.builder.fluent.Configurations;
import org.apache.commons.configuration2.tree.ImmutableNode;

public class QuicknoteConfig {
    private BaseHierarchicalConfiguration config;

    public synchronized BaseHierarchicalConfiguration globalConfig() {
        if (this.config == null) {
            this.loadConfig();
        }
        return this.config;
    }

    public HierarchicalConfiguration<ImmutableNode> configForConnector(String name) {
        return this.loadChildOrThrowConfigException("quicknote.connectors." + name);
    }

    public HierarchicalConfiguration<ImmutableNode> configForSender(String name) {
        return this.loadChildOrThrowConfigException("quicknote.senders." + name);
    }

    public HierarchicalConfiguration<ImmutableNode> configForReceiver(String name) {
        return this.loadChildOrThrowConfigException("quicknote.receivers." + name);
    }

    public static String requireStringNotEmpty(Configuration c, String path) throws ConfigException {
        String val = c.getString(path, null);
        if (val == null || val.isEmpty()) {
            throw new ConfigException("Required configuration property '" + path + "' not found.");
        }
        return val;
    }

    private void loadConfig() {
        try {
            this.initDotEnv();
            YAMLConfiguration c = (YAMLConfiguration)new Configurations().fileBased(YAMLConfiguration.class, "quicknote.yaml");
            c.getInterpolator().addDefaultLookup(System::getenv);
            c.getInterpolator().addDefaultLookup(System::getProperty);
            this.config = c;
        }
        catch (Exception exc) {
            throw new ConfigException("Cannot initialize Quicknote configuration.", exc);
        }
    }

    private HierarchicalConfiguration<ImmutableNode> loadChildOrThrowConfigException(String name) {
        HierarchicalConfiguration cfg = this.globalConfig().configurationAt(name);
        if (cfg == null) {
            throw new ConfigException("missing: " + name);
        }
        return cfg;
    }

    private void initDotEnv() {
        Dotenv.configure().ignoreIfMissing().systemProperties().load();
    }
}

