/*
 * Decompiled with CFR 0.152.
 */
package io.adamantic.quicknote;

import io.adamantic.quicknote.Connector;
import io.adamantic.quicknote.QuicknoteConfig;
import io.adamantic.quicknote.Receiver;
import io.adamantic.quicknote.Sender;
import io.adamantic.quicknote.exceptions.ChannelNotFound;
import io.adamantic.quicknote.exceptions.ConfigException;
import io.adamantic.quicknote.types.ChannelState;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Quicknote {
    private static final Logger log = LoggerFactory.getLogger(Quicknote.class);
    private static String clientId = UUID.randomUUID().toString();
    private final QuicknoteConfig config;
    private final Map<String, Connector> connectors = new HashMap<String, Connector>();
    private static Quicknote instance;

    public static void clientId(String id) {
        clientId = id;
    }

    public static synchronized Quicknote instance() {
        if (instance == null) {
            instance = new Quicknote();
        }
        return instance;
    }

    private Quicknote() {
        this.config = new QuicknoteConfig();
        this.config.globalConfig();
        log.info("Quicknote subsystem initialized.");
    }

    public Sender sender(String name) throws ChannelNotFound {
        return this.delegateSender(name);
    }

    public Receiver receiver(String name) throws ChannelNotFound {
        return this.delegateReceiver(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connector connector(String name) {
        Map<String, Connector> map = this.connectors;
        synchronized (map) {
            Connector conn = this.connectors.get(name);
            if (conn != null) {
                if (conn.state() == ChannelState.OPEN) {
                    return conn;
                }
                log.warn("Connector found for name [{}], but status is [{}], re-creating", (Object)name, (Object)conn.state().name());
                conn.close();
            }
            return this.createConnector(name);
        }
    }

    private Connector createConnector(String name) {
        log.debug("Attempting to create connector [{}]", (Object)name);
        HierarchicalConfiguration<ImmutableNode> connConfig = this.config.configForConnector(name);
        String connClass = connConfig.getString("class");
        if (connClass == null) {
            throw new ConfigException("[class] is not set for connector [" + name + "]");
        }
        try {
            Class<?> clsInstance = Class.forName(connClass);
            Connector cnn = (Connector)clsInstance.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            cnn.initialize(this.config);
            cnn.open();
            this.connectors.put(name, cnn);
            log.info("Created and started new connector [{}]", (Object)name);
            return cnn;
        }
        catch (Exception exc) {
            throw new ConfigException("Cannot create connector [" + name + "]", exc);
        }
    }

    private Sender delegateSender(String name) throws ChannelNotFound {
        log.debug("Getting or creating sender [{}]", (Object)name);
        HierarchicalConfiguration<ImmutableNode> senderConfig = this.config.configForSender(name);
        String connName = senderConfig.getString("connector");
        if (connName == null) {
            throw new ConfigException("[connector] is not set for sender [" + name + "]");
        }
        Connector conn = this.connector(connName);
        return conn.sender(name);
    }

    private Receiver delegateReceiver(String name) throws ChannelNotFound {
        log.debug("Getting or creating receiver [{}]", (Object)name);
        HierarchicalConfiguration<ImmutableNode> receiverConfig = this.config.configForReceiver(name);
        String connName = receiverConfig.getString("connector");
        if (connName == null) {
            throw new ConfigException("[connector] is not set for receiver [" + name + "]");
        }
        Connector conn = this.connector(connName);
        return conn.receiver(name);
    }

    public static String clientId() {
        return clientId;
    }

    public QuicknoteConfig config() {
        return this.config;
    }
}

