/*
 * Decompiled with CFR 0.152.
 */
package im.amomo.loading.indicator;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.graphics.Canvas;
import android.graphics.Paint;
import im.amomo.loading.indicator.BaseIndicatorController;
import java.util.ArrayList;
import java.util.List;

public class BallGridPulseIndicator
extends BaseIndicatorController {
    public static final int ALPHA = 255;
    public static final float SCALE = 1.0f;
    int[] alphas = new int[]{255, 255, 255, 255, 255, 255, 255, 255, 255};
    float[] scaleFloats = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f};

    @Override
    public void draw(Canvas canvas, Paint paint) {
        float circleSpacing = 4.0f;
        float radius = ((float)this.getWidth() - circleSpacing * 4.0f) / 6.0f;
        float x = (float)(this.getWidth() / 2) - (radius * 2.0f + circleSpacing);
        float y = (float)(this.getWidth() / 2) - (radius * 2.0f + circleSpacing);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                canvas.save();
                float translateX = x + radius * 2.0f * (float)j + circleSpacing * (float)j;
                float translateY = y + radius * 2.0f * (float)i + circleSpacing * (float)i;
                canvas.translate(translateX, translateY);
                canvas.scale(this.scaleFloats[3 * i + j], this.scaleFloats[3 * i + j]);
                paint.setAlpha(this.alphas[3 * i + j]);
                canvas.drawCircle(0.0f, 0.0f, radius, paint);
                canvas.restore();
            }
        }
    }

    @Override
    public List<Animator> createAnimation() {
        ArrayList<Animator> animators = new ArrayList<Animator>();
        int[] durations = new int[]{720, 1020, 1280, 1420, 1450, 1180, 870, 1450, 1060};
        int[] delays = new int[]{-60, 250, -170, 480, 310, 30, 460, 780, 450};
        for (int i = 0; i < 9; ++i) {
            final int index = i;
            ValueAnimator scaleAnim = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.5f, 1.0f});
            scaleAnim.setDuration((long)durations[i]);
            scaleAnim.setRepeatCount(-1);
            scaleAnim.setStartDelay((long)delays[i]);
            scaleAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    BallGridPulseIndicator.this.scaleFloats[index] = ((Float)animation.getAnimatedValue()).floatValue();
                    BallGridPulseIndicator.this.postInvalidate();
                }
            });
            scaleAnim.start();
            ValueAnimator alphaAnim = ValueAnimator.ofInt((int[])new int[]{255, 210, 122, 255});
            alphaAnim.setDuration((long)durations[i]);
            alphaAnim.setRepeatCount(-1);
            alphaAnim.setStartDelay((long)delays[i]);
            alphaAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    BallGridPulseIndicator.this.alphas[index] = (Integer)animation.getAnimatedValue();
                    BallGridPulseIndicator.this.postInvalidate();
                }
            });
            alphaAnim.start();
            animators.add((Animator)scaleAnim);
            animators.add((Animator)alphaAnim);
        }
        return animators;
    }
}

