/*
 * Decompiled with CFR 0.152.
 */
package data;

import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Cache;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;
import org.jetbrains.annotations.NotNull;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.gson.GsonConverterFactory;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000f"}, d2={"SIZE_10MB", "", "okCache10Mb", "Lokhttp3/Cache;", "getOkCache10Mb", "()Lokhttp3/Cache;", "overrideCacheControlInterceptor", "Lokhttp3/Interceptor;", "getOverrideCacheControlInterceptor", "()Lokhttp3/Interceptor;", "retrofit", "Lretrofit2/Retrofit;", "baseUrl", "", "authorization", "BuildChecks"})
public final class RetrofitsKt {
    public static final long SIZE_10MB = 0xA00000L;
    @NotNull
    private static final Cache okCache10Mb = new Cache(new File("/tmp"), 0xA00000L);
    @NotNull
    private static final Interceptor overrideCacheControlInterceptor = RetrofitsKt::overrideCacheControlInterceptor$lambda$0;

    @NotNull
    public static final Cache getOkCache10Mb() {
        return okCache10Mb;
    }

    @NotNull
    public static final Interceptor getOverrideCacheControlInterceptor() {
        return overrideCacheControlInterceptor;
    }

    @NotNull
    public static final Retrofit retrofit(@NotNull String baseUrl, @NotNull String authorization) {
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter((Object)authorization, (String)"authorization");
        Interceptor authHeaderInterceptor = arg_0 -> RetrofitsKt.retrofit$lambda$1(authorization, arg_0);
        OkHttpClient.Builder authClient = new OkHttpClient.Builder().cache(okCache10Mb).addInterceptor(authHeaderInterceptor).addInterceptor((Interceptor)new HttpLoggingInterceptor().setLevel(HttpLoggingInterceptor.Level.BODY));
        authClient.networkInterceptors().add(overrideCacheControlInterceptor);
        HttpUrl httpUrl = HttpUrl.parse((String)baseUrl);
        if (httpUrl == null) {
            HttpUrl httpUrl2 = HttpUrl.parse((String)"https://localhost");
            httpUrl = httpUrl2;
            Intrinsics.checkNotNull((Object)httpUrl2);
        }
        HttpUrl httpUrl3 = httpUrl;
        Retrofit retrofit2 = new Retrofit.Builder().addConverterFactory((Converter.Factory)GsonConverterFactory.create()).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).baseUrl(httpUrl3).client(authClient.build()).build();
        Intrinsics.checkNotNullExpressionValue((Object)retrofit2, (String)"Builder()\n            .a\u2026d())\n            .build()");
        return retrofit2;
    }

    private static final Response overrideCacheControlInterceptor$lambda$0(Interceptor.Chain chain) {
        boolean isOverride = Intrinsics.areEqual((Object)chain.request().header("X-override-cache-control"), (Object)"true");
        String cacheControl = chain.request().header("Cache-Control");
        Response response = chain.proceed(chain.request());
        if (isOverride && cacheControl != null) {
            response = response.newBuilder().header("Cache-Control", cacheControl + ", X-override-cache-control=true").build();
        }
        return response;
    }

    private static final Response retrofit$lambda$1(String $authorization, Interceptor.Chain chain) {
        Intrinsics.checkNotNullParameter((Object)$authorization, (String)"$authorization");
        Request request = chain.request().newBuilder().addHeader("Authorization", $authorization).build();
        return chain.proceed(request);
    }
}

