/*
 * Decompiled with CFR 0.152.
 */
package core.usecase;

import core.FilesKt;
import core.entity.BuildConfig;
import core.entity.InfoMessage;
import core.entity.Log;
import core.entity.Message;
import core.entity.Stats;
import core.usecase.BuildReport;
import core.usecase.DirectoryReport;
import core.usecase.GetDurationSummaryUseCase;
import core.usecase.GetSummaryUseCase;
import core.usecase.GetSummaryUseCaseKt;
import core.usecase.HtmlReportKt;
import core.usecase.Link;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002\u001a\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005*\b\u0012\u0004\u0012\u00020\u00020\u0005\u001a&\u0010\u0006\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007\u0018\u00010\u0005*\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001a\n\u0010\f\u001a\u00020\r*\u00020\t\u001a\u0010\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0005*\u00020\t\u00a8\u0006\u0010"}, d2={"asLink", "Lcore/usecase/Link;", "Ljava/io/File;", "relativeRootDir", "readables", "", "statsHistory", "", "", "Lcore/entity/BuildConfig;", "currentStats", "Lcore/entity/Stats;", "toBuildReport", "Lcore/usecase/BuildReport;", "toDirectoryReports", "Lcore/usecase/DirectoryReport;", "BuildChecks"})
@SourceDebugExtension(value={"SMAP\nBuildReport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildReport.kt\ncore/usecase/BuildReportKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,67:1\n764#2:68\n855#2,2:69\n1547#2:71\n1618#2,3:72\n764#2:78\n855#2,2:79\n1547#2:81\n1618#2,3:82\n764#2:86\n855#2,2:87\n1849#2,2:90\n11328#3:75\n11663#3,2:76\n11665#3:85\n1#4:89\n*S KotlinDebug\n*F\n+ 1 BuildReport.kt\ncore/usecase/BuildReportKt\n*L\n36#1:68\n36#1:69,2\n36#1:71\n36#1:72,3\n49#1:78\n49#1:79,2\n50#1:81\n50#1:82,3\n55#1:86\n55#1:87,2\n64#1:90,2\n45#1:75\n45#1:76,2\n45#1:85\n*E\n"})
public final class BuildReportKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final BuildReport toBuildReport(@NotNull BuildConfig $this$toBuildReport) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        File it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)$this$toBuildReport, (String)"<this>");
        File artifactsDir = FilesKt.copyEachRecursively($this$toBuildReport.reportDirs(), $this$toBuildReport.artifactsDir());
        Log log = $this$toBuildReport.getLog();
        if (log != null) {
            log.info(new InfoMessage("Building summary reports in " + artifactsDir + "...").toString());
        }
        List<File> allReportFiles = FilesKt.findReportFiles(artifactsDir);
        List<GetSummaryUseCase> buildSummaries = GetSummaryUseCaseKt.toSummaries(allReportFiles, $this$toBuildReport);
        Stats stats = GetSummaryUseCaseKt.toStats(buildSummaries, $this$toBuildReport);
        Iterable iterable = allReportFiles;
        List<Message> list = GetSummaryUseCaseKt.toMessages(buildSummaries);
        boolean $i$f$filter = false;
        void var7_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (File)element$iv$iv;
            boolean bl = false;
            if (!FilesKt.isXML(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(BuildReportKt.asLink(it, artifactsDir));
        }
        List<Map<String, String>> list2 = BuildReportKt.statsHistory($this$toBuildReport, stats);
        Stats stats2 = stats;
        String string = $this$toBuildReport.getGit().summary();
        List<DirectoryReport> list3 = BuildReportKt.toDirectoryReports($this$toBuildReport);
        List list4 = (List)destination$iv$iv;
        List<Message> list5 = list;
        return new BuildReport(list5, list4, list3, string, stats2, list2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<DirectoryReport> toDirectoryReports(@NotNull BuildConfig $this$toDirectoryReports) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$toDirectoryReports, (String)"<this>");
        File[] fileArray = FilesKt.subdirs($this$toDirectoryReports.artifactsDir());
        if (fileArray != null) {
            void $this$mapTo$iv$iv;
            File[] $this$map$iv = fileArray;
            boolean $i$f$map = false;
            File[] fileArray2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            void var6_6 = $this$mapTo$iv$iv;
            int n = ((void)var6_6).length;
            for (int i = 0; i < n; ++i) {
                Collection<Link> collection;
                void $this$mapTo$iv$iv2;
                void $this$map$iv2;
                Object it;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                void dir;
                void item$iv$iv;
                void var10_10 = item$iv$iv = var6_6[i];
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                List<File> reportFiles = FilesKt.findReportFiles((File)dir);
                Iterable iterable = GetSummaryUseCaseKt.toSummaries(reportFiles, $this$toDirectoryReports);
                Link link = BuildReportKt.asLink((File)dir, $this$toDirectoryReports.artifactsDir());
                boolean $i$f$filter = false;
                void var16_16 = $this$filter$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (GetSummaryUseCase)element$iv$iv;
                    boolean bl2 = false;
                    if (!(!(it instanceof GetDurationSummaryUseCase))) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                $this$filter$iv = BuildReportKt.readables(reportFiles);
                List<Message> list2 = GetSummaryUseCaseKt.toMessages((List)destination$iv$iv2);
                boolean $i$f$map2 = false;
                $this$filterTo$iv$iv = $this$map$iv2;
                destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    it = (File)item$iv$iv2;
                    collection = destination$iv$iv2;
                    boolean bl3 = false;
                    collection.add(BuildReportKt.asLink((File)it, $this$toDirectoryReports.artifactsDir()));
                }
                collection = (List)destination$iv$iv2;
                List list3 = collection;
                List<Message> list4 = list2;
                Link link2 = link;
                collection2.add(new DirectoryReport(link2, list4, list3));
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<File> readables(@NotNull List<? extends File> $this$readables) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$readables, (String)"<this>");
        Iterable $this$filter$iv = $this$readables;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            File it = (File)element$iv$iv;
            boolean bl = false;
            if (!FilesKt.isReadableFormat(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final Link asLink(@NotNull File $this$asLink, @NotNull File relativeRootDir) {
        Pair<String, File> pair;
        Intrinsics.checkNotNullParameter((Object)$this$asLink, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)relativeRootDir, (String)"relativeRootDir");
        Pair<String, File> it = pair = FilesKt.toNameAndPathPair($this$asLink, relativeRootDir);
        boolean bl = false;
        return new Link((String)it.getFirst(), (File)it.getSecond());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final List<Map<String, String>> statsHistory(@NotNull BuildConfig $this$statsHistory, @NotNull Stats currentStats) {
        List<Map<String, String>> list;
        Intrinsics.checkNotNullParameter((Object)$this$statsHistory, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)currentStats, (String)"currentStats");
        if (!StringsKt.isBlank((CharSequence)$this$statsHistory.getArtifactsBranch()) && $this$statsHistory.isPushActivated()) {
            void var3_3;
            Log log = $this$statsHistory.getLog();
            if (log != null) {
                log.info(new InfoMessage("Building history chart from '" + $this$statsHistory.getArtifactsBranch() + "' branch log...").toString());
            }
            String commits = GitsKt.getCommitLog($this$statsHistory.tempDir(), $this$statsHistory.getArtifactsBranch(), $this$statsHistory.getLog());
            Log log2 = $this$statsHistory.getLog();
            if (log2 != null) {
                log2.info(new InfoMessage("Extract stat history from csv commit messages...").toString());
            }
            List<Map<String, String>> mapsList = HtmlReportKt.csvToMapsList(commits + '\n' + currentStats);
            Iterable $this$forEach$iv = mapsList;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map it = (Map)element$iv;
                boolean bl = false;
                Log log3 = $this$statsHistory.getLog();
                if (log3 == null) continue;
                log3.info(new InfoMessage(String.valueOf(it)).toString());
            }
            list = var3_3;
        } else {
            list = null;
        }
        return list;
    }
}

