/*
 * Decompiled with CFR 0.152.
 */
package core;

import core.entity.BuildConfig;
import core.entity.Message;
import core.entity.ProjectConfig;
import core.usecase.GetSummaryUseCase;
import core.usecase.GetSummaryUseCaseKt;
import core.usecase.HandleBuildFinishedUseCase;
import core.usecase.HandleBuildStartedUseCase;
import core.usecase.PostStatsUseCase;
import core.usecase.PostStatusUseCase;
import data.BuildPostStatusDatasourcesKt;
import data.RetrofitStatsDatasourceKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0013J\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015J\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u001aR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001b"}, d2={"Lcore/Registry;", "", "projectConfig", "Lcore/entity/ProjectConfig;", "(Lcore/entity/ProjectConfig;)V", "config", "Lcore/entity/BuildConfig;", "getConfig", "()Lcore/entity/BuildConfig;", "messages", "", "Lcore/entity/Message;", "getProjectConfig", "()Lcore/entity/ProjectConfig;", "provideBuildFinishedUseCase", "Lcore/usecase/HandleBuildFinishedUseCase;", "isSuccess", "", "provideBuildStartedUseCase", "Lcore/usecase/HandleBuildStartedUseCase;", "provideGetSummaryUseCases", "", "Lcore/usecase/GetSummaryUseCase;", "providePostStatsUseCase", "Lcore/usecase/PostStatsUseCase;", "providePostStatusUseCase", "Lcore/usecase/PostStatusUseCase;", "BuildChecks"})
public final class Registry {
    @NotNull
    private final ProjectConfig projectConfig;
    @NotNull
    private final List<Message> messages;
    @NotNull
    private final BuildConfig config;

    public Registry(@NotNull ProjectConfig projectConfig) {
        Intrinsics.checkNotNullParameter((Object)projectConfig, (String)"projectConfig");
        this.projectConfig = projectConfig;
        this.messages = new ArrayList();
        this.config = this.projectConfig.createBuildChecksConfig();
    }

    @NotNull
    public final ProjectConfig getProjectConfig() {
        return this.projectConfig;
    }

    @NotNull
    public final BuildConfig getConfig() {
        return this.config;
    }

    @NotNull
    public final List<GetSummaryUseCase> provideGetSummaryUseCases() {
        return GetSummaryUseCaseKt.toSummaries(this.config.reportFiles(), this.config);
    }

    @NotNull
    public final PostStatsUseCase providePostStatsUseCase() {
        return new PostStatsUseCase(RetrofitStatsDatasourceKt.buildList(PostStatsUseCase.Datasource.Companion, this.config));
    }

    @NotNull
    public final PostStatusUseCase providePostStatusUseCase() {
        return new PostStatusUseCase(BuildPostStatusDatasourcesKt.buildList(PostStatusUseCase.Datasource.Companion, this.config), this.config, this.messages);
    }

    @NotNull
    public final HandleBuildStartedUseCase provideBuildStartedUseCase() {
        BuildConfig buildConfig;
        BuildConfig $this$provideBuildStartedUseCase_u24lambda_u240 = buildConfig = this.config;
        boolean bl = false;
        $this$provideBuildStartedUseCase_u24lambda_u240.setTaskName(this.projectConfig.taskNameString());
        $this$provideBuildStartedUseCase_u24lambda_u240.setPostActivated(this.projectConfig.isPostChecksActivated());
        $this$provideBuildStartedUseCase_u24lambda_u240.setChecksActivated(this.projectConfig.isChecksActivated());
        $this$provideBuildStartedUseCase_u24lambda_u240.setPushActivated(this.projectConfig.isPushArtifactsActivated());
        $this$provideBuildStartedUseCase_u24lambda_u240.setOpenActivated(this.projectConfig.isOpenChecksActivated());
        $this$provideBuildStartedUseCase_u24lambda_u240.setLog(this.projectConfig.logger());
        return new HandleBuildStartedUseCase(this.providePostStatusUseCase(), this.config);
    }

    @NotNull
    public final HandleBuildFinishedUseCase provideBuildFinishedUseCase(boolean isSuccess) {
        this.config.setSuccess(isSuccess);
        return new HandleBuildFinishedUseCase(this.providePostStatusUseCase(), this.providePostStatsUseCase(), this.provideGetSummaryUseCases(), this.config, this.messages);
    }
}

