/*
 * Decompiled with CFR 0.152.
 */
package core;

import core.DocumentsKt;
import core.FilesKt;
import core.entity.ErrorMessage;
import core.entity.InfoMessage;
import core.entity.Log;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\u0018\u0010\u0003\u001a\u00020\u0002*\b\u0012\u0004\u0012\u00020\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0002\u001a\u0010\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004*\u00020\u0002\u001a\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u0002*\b\u0012\u0004\u0012\u00020\u00020\u0004\u001a\n\u0010\b\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\t\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\n\u001a\u00020\u0001*\u00020\u0002\u001a\u0017\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\f*\u00020\u0002\u00a2\u0006\u0002\u0010\r\u001a\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004*\u00020\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u001a\u001e\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00020\u0013*\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0002\u001a\u0018\u0010\u0015\u001a\u00020\u000f*\u00020\u000f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0017\u001a\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0004*\b\u0012\u0004\u0012\u00020\u00020\u0004\u00a8\u0006\u001a"}, d2={"containsIndexHTML", "", "Ljava/io/File;", "copyEachRecursively", "", "targetDir", "findReportFiles", "firstDir", "isIndexHTML", "isReadableFormat", "isXML", "subdirs", "", "(Ljava/io/File;)[Ljava/io/File;", "toFileList", "", "log", "Lcore/entity/Log;", "toNameAndPathPair", "Lkotlin/Pair;", "relativeRootDir", "toShortUid", "items", "", "toXmlDocuments", "Lorg/w3c/dom/Document;", "BuildChecks"})
@SourceDebugExtension(value={"SMAP\nFiles.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Files.kt\ncore/FilesKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,49:1\n764#2:50\n855#2,2:51\n1547#2:53\n1618#2,3:54\n764#2:57\n855#2,2:58\n2574#2,7:60\n2574#2,7:67\n1547#2:74\n1618#2,3:75\n1849#2,2:78\n286#2,2:80\n764#2:85\n855#2,2:86\n1#3:82\n12701#4,2:83\n*S KotlinDebug\n*F\n+ 1 Files.kt\ncore/FilesKt\n*L\n10#1:50\n10#1:51,2\n11#1:53\n11#1:54,3\n19#1:57\n19#1:58,2\n23#1:60,7\n24#1:67,7\n29#1:74\n29#1:75,3\n30#1:78,2\n34#1:80,2\n44#1:85\n44#1:86,2\n43#1:83,2\n*E\n"})
public final class FilesKt {
    @NotNull
    public static final List<File> toFileList(@NotNull String $this$toFileList, @Nullable Log log) {
        Iterable $this$mapTo$iv$iv;
        Object it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$toFileList, (String)"<this>");
        String[] stringArray = new String[]{","};
        Iterable $this$filter$iv = StringsKt.split$default((CharSequence)$this$toFileList, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            String string = it;
            if (string == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            boolean bl2 = ((CharSequence)((Object)StringsKt.trim((CharSequence)string)).toString()).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it;
            if (string == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            File f = new File(((Object)StringsKt.trim((CharSequence)string)).toString());
            if (log != null) {
                if (f.exists()) {
                    log.debug(new InfoMessage("BuildChecks found: " + f.getAbsolutePath()).toString());
                } else {
                    log.debug(new ErrorMessage("BuildChecks could not find: " + f.getAbsolutePath()).toString());
                }
            }
            collection.add(f);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (File)element$iv$iv;
            boolean bl = false;
            if (!((File)it).exists()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List toFileList$default(String string, Log log, int n, Object object) {
        if ((n & 1) != 0) {
            log = null;
        }
        return FilesKt.toFileList(string, log);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String toShortUid(@NotNull String $this$toShortUid, @NotNull Set<String> items) {
        String string;
        Object v2;
        String string2;
        String acc;
        Object v0;
        Intrinsics.checkNotNullParameter((Object)$this$toShortUid, (String)"<this>");
        Intrinsics.checkNotNullParameter(items, (String)"items");
        Iterable $this$reduceOrNull$iv = items;
        boolean $i$f$reduceOrNull = false;
        Iterator iterator$iv = $this$reduceOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void path;
                String string3 = (String)iterator$iv.next();
                acc = (String)accumulator$iv;
                boolean bl = false;
                accumulator$iv = StringsKt.commonPrefixWith$default((CharSequence)((CharSequence)path), (CharSequence)acc, (boolean)false, (int)2, null);
            }
            v0 = accumulator$iv;
        }
        if ((string2 = (String)v0) == null) {
            string2 = "";
        }
        String prefix = string2;
        Iterable $this$reduceOrNull$iv2 = items;
        boolean $i$f$reduceOrNull2 = false;
        Iterator iterator$iv2 = $this$reduceOrNull$iv2.iterator();
        if (!iterator$iv2.hasNext()) {
            v2 = null;
        } else {
            Object accumulator$iv = iterator$iv2.next();
            while (iterator$iv2.hasNext()) {
                void path;
                acc = (String)iterator$iv2.next();
                String acc2 = (String)accumulator$iv;
                boolean bl = false;
                accumulator$iv = StringsKt.commonSuffixWith$default((CharSequence)((CharSequence)path), (CharSequence)acc2, (boolean)false, (int)2, null);
            }
            v2 = accumulator$iv;
        }
        if ((string = (String)v2) == null) {
            string = "";
        }
        String suffix = string;
        String string4 = StringsKt.removeSuffix((String)StringsKt.removePrefix((String)$this$toShortUid, (CharSequence)prefix), (CharSequence)suffix);
        String string5 = File.separator;
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"separator");
        return StringsKt.replace$default((String)string4, (String)string5, (String)"-", (boolean)false, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final File copyEachRecursively(@NotNull List<? extends File> $this$copyEachRecursively, @NotNull File targetDir) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$copyEachRecursively, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)targetDir, (String)"targetDir");
        Iterable $this$map$iv = $this$copyEachRecursively;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getAbsolutePath());
        }
        Set paths = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $this$forEach$iv = $this$copyEachRecursively;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            String string = it.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.absolutePath");
            kotlin.io.FilesKt.copyRecursively$default((File)it, (File)new File(targetDir, FilesKt.toShortUid(string, paths)), (boolean)true, null, (int)4, null);
        }
        return targetDir;
    }

    @Nullable
    public static final File firstDir(@NotNull List<? extends File> $this$firstDir) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter($this$firstDir, (String)"<this>");
            Iterable $this$firstOrNull$iv = $this$firstDir;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                File it = (File)element$iv;
                boolean bl = false;
                if (!it.isDirectory()) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @NotNull
    public static final Pair<String, File> toNameAndPathPair(@NotNull File $this$toNameAndPathPair, @NotNull File relativeRootDir) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$toNameAndPathPair, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)relativeRootDir, (String)"relativeRootDir");
        if (FilesKt.isIndexHTML($this$toNameAndPathPair)) {
            File file = $this$toNameAndPathPair.getParentFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"parentFile");
            string = kotlin.io.FilesKt.relativeTo((File)file, (File)relativeRootDir).getPath();
        } else {
            string = kotlin.io.FilesKt.relativeTo((File)$this$toNameAndPathPair, (File)relativeRootDir).getPath();
        }
        String name = string;
        return TuplesKt.to((Object)name, (Object)kotlin.io.FilesKt.relativeTo((File)$this$toNameAndPathPair, (File)relativeRootDir));
    }

    public static final boolean isReadableFormat(@NotNull File $this$isReadableFormat) {
        Intrinsics.checkNotNullParameter((Object)$this$isReadableFormat, (String)"<this>");
        String string = $this$isReadableFormat.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
        String string2 = string;
        String string3 = string2.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        String $this$isReadableFormat_u24lambda_u248 = string2 = string3;
        boolean bl = false;
        return StringsKt.endsWith$default((String)$this$isReadableFormat_u24lambda_u248, (String)".html", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)$this$isReadableFormat_u24lambda_u248, (String)".txt", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)$this$isReadableFormat_u24lambda_u248, (String)".text", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)$this$isReadableFormat_u24lambda_u248, (String)".md", (boolean)false, (int)2, null);
    }

    public static final boolean isXML(@NotNull File $this$isXML) {
        Intrinsics.checkNotNullParameter((Object)$this$isXML, (String)"<this>");
        String string = $this$isXML.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
        String string2 = string;
        String string3 = string2.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        return StringsKt.endsWith$default((String)string3, (String)".xml", (boolean)false, (int)2, null);
    }

    public static final boolean isIndexHTML(@NotNull File $this$isIndexHTML) {
        Intrinsics.checkNotNullParameter((Object)$this$isIndexHTML, (String)"<this>");
        String string = $this$isIndexHTML.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
        String string2 = string;
        String string3 = string2.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        return Intrinsics.areEqual((Object)string3, (Object)"index.html");
    }

    public static final boolean containsIndexHTML(@NotNull File $this$containsIndexHTML) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$containsIndexHTML, (String)"<this>");
            File[] fileArray = $this$containsIndexHTML.listFiles();
            if (fileArray != null) {
                File[] $this$any$iv = fileArray;
                boolean $i$f$any = false;
                File[] fileArray2 = $this$any$iv;
                int n = fileArray2.length;
                for (int i = 0; i < n; ++i) {
                    File element$iv;
                    File it = element$iv = fileArray2[i];
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    if (!FilesKt.isIndexHTML(it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            } else {
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Document> toXmlDocuments(@NotNull List<? extends File> $this$toXmlDocuments) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$toXmlDocuments, (String)"<this>");
        Iterable $this$filter$iv = $this$toXmlDocuments;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            File it = (File)element$iv$iv;
            boolean bl = false;
            if (!FilesKt.isXML(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return DocumentsKt.toDocumentList((List)destination$iv$iv);
    }

    @NotNull
    public static final List<File> findReportFiles(@NotNull File $this$findReportFiles) {
        Intrinsics.checkNotNullParameter((Object)$this$findReportFiles, (String)"<this>");
        return SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)((Sequence)kotlin.io.FilesKt.walkTopDown((File)$this$findReportFiles).onEnter((Function1)findReportFiles.1.INSTANCE)), (Function1)findReportFiles.2.INSTANCE));
    }

    @Nullable
    public static final File[] subdirs(@NotNull File $this$subdirs) {
        Intrinsics.checkNotNullParameter((Object)$this$subdirs, (String)"<this>");
        return $this$subdirs.listFiles(FilesKt::subdirs$lambda$11);
    }

    private static final boolean subdirs$lambda$11(File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isDirectory();
    }
}

