/*
 * Decompiled with CFR 0.152.
 */
import core.UtilsKt;
import core.entity.BuildConfig;
import core.entity.ErrorMessage;
import core.entity.InfoMessage;
import core.entity.Log;
import core.entity.Message;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u001a\u000e\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u0005\u001a\"\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u001a&\u0010\u000b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\f\u001a\u00020\u00032\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u001a\b\u0010\r\u001a\u0004\u0018\u00010\u0005\u001a \u0010\u000e\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u001a*\u0010\u000f\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u001a\u0018\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u001a\u0018\u0010\u000f\u001a\u00020\u0001*\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u00a8\u0006\u0016"}, d2={"commitAll", "", "tempDir", "Ljava/io/File;", "commitMessage", "", "log", "Lcore/entity/Log;", "deleteBranch", "branchName", "getCommitLog", "gitShallowClone", "tempPath", "gitUrl", "initOrphanBranch", "pushArtifacts", "sourceDir", "removeAll", "Lcore/entity/BuildConfig;", "messageQueue", "", "Lcore/entity/Message;", "BuildChecks"})
@SourceDebugExtension(value={"SMAP\nGits.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Gits.kt\nGitsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,60:1\n1#2:61\n*E\n"})
public final class GitsKt {
    public static final void pushArtifacts(@NotNull BuildConfig $this$pushArtifacts, @NotNull List<Message> messageQueue) {
        Intrinsics.checkNotNullParameter((Object)$this$pushArtifacts, (String)"<this>");
        Intrinsics.checkNotNullParameter(messageQueue, (String)"messageQueue");
        if ($this$pushArtifacts.isPushActivated()) {
            if (!StringsKt.isBlank((CharSequence)$this$pushArtifacts.getArtifactsBranch())) {
                GitsKt.pushArtifacts($this$pushArtifacts.getArtifactsBranch(), $this$pushArtifacts.artifactsDir(), $this$pushArtifacts.tempDir(), $this$pushArtifacts.getLog());
            } else {
                messageQueue.add(new ErrorMessage("To run 'pushArtifacts', your BuildChecks config must define an artifactsBranch"));
            }
        }
    }

    public static final void pushArtifacts(@NotNull String branchName, @Nullable File sourceDir, @NotNull File tempDir, @Nullable Log log) {
        Intrinsics.checkNotNullParameter((Object)branchName, (String)"branchName");
        Intrinsics.checkNotNullParameter((Object)tempDir, (String)"tempDir");
        if (sourceDir == null) {
            return;
        }
        Log log2 = log;
        if (log2 != null) {
            log2.info(new InfoMessage("Executing pushArtifacts...").toString());
        }
        FilesKt.deleteRecursively((File)tempDir);
        GitsKt.gitShallowClone(tempDir, branchName, log);
        if (!tempDir.exists()) {
            GitsKt.initOrphanBranch(tempDir, branchName, log);
        }
        GitsKt.removeAll(tempDir, log);
        FilesKt.copyRecursively$default((File)sourceDir, (File)tempDir, (boolean)false, null, (int)6, null);
        GitsKt.commitAll(tempDir, FilesKt.readText$default((File)new File(sourceDir, "stats.csv"), null, (int)1, null), log);
        UtilsKt.runCommand("git push --set-upstream origin " + branchName, tempDir, log);
        String string = new InfoMessage("Pushed " + sourceDir.getPath() + " to " + branchName + " branch of " + GitsKt.gitUrl()).toString();
        System.out.println((Object)string);
    }

    public static final void initOrphanBranch(@NotNull File tempDir, @NotNull String branchName, @Nullable Log log) {
        Intrinsics.checkNotNullParameter((Object)tempDir, (String)"tempDir");
        Intrinsics.checkNotNullParameter((Object)branchName, (String)"branchName");
        tempDir.mkdir();
        GitsKt.gitShallowClone(tempDir, null, null);
        UtilsKt.runCommand("git checkout --orphan " + branchName, tempDir, log);
    }

    public static final void removeAll(@NotNull File tempDir, @Nullable Log log) {
        Intrinsics.checkNotNullParameter((Object)tempDir, (String)"tempDir");
        UtilsKt.runCommand("git rm -rfq --ignore-unmatch .", tempDir, log);
        UtilsKt.runCommand("git clean -dfq", tempDir, log);
    }

    public static final void commitAll(@NotNull File tempDir, @NotNull String commitMessage, @Nullable Log log) {
        Intrinsics.checkNotNullParameter((Object)tempDir, (String)"tempDir");
        Intrinsics.checkNotNullParameter((Object)commitMessage, (String)"commitMessage");
        UtilsKt.runCommand("git add .", tempDir, log);
        UtilsKt.runCommand("git commit -q -m \"" + commitMessage + '\"', tempDir, log);
    }

    public static final void deleteBranch(@NotNull String branchName) {
        Intrinsics.checkNotNullParameter((Object)branchName, (String)"branchName");
        UtilsKt.run("git branch -d " + branchName);
        UtilsKt.run("git push origin --delete " + branchName);
    }

    @Nullable
    public static final String getCommitLog(@NotNull File tempDir, @NotNull String branchName, @Nullable Log log) {
        Intrinsics.checkNotNullParameter((Object)tempDir, (String)"tempDir");
        Intrinsics.checkNotNullParameter((Object)branchName, (String)"branchName");
        FilesKt.deleteRecursively((File)tempDir);
        UtilsKt.runCommand("git clone " + GitsKt.gitUrl() + ' ' + tempDir.getPath() + " --branch " + branchName, new File("."), log);
        return UtilsKt.runCommand("git --no-pager log --pretty=tformat:%B", tempDir, log);
    }

    @Nullable
    public static final String gitUrl() {
        return UtilsKt.run("git config --get remote.origin.url");
    }

    @Nullable
    public static final String gitShallowClone(@NotNull File tempPath, @Nullable String branchName, @Nullable Log log) {
        String string;
        block3: {
            block2: {
                String string2;
                Intrinsics.checkNotNullParameter((Object)tempPath, (String)"tempPath");
                string = branchName;
                if (string == null) break block2;
                String it = string2 = string;
                boolean bl = false;
                String string3 = " --branch " + branchName;
                string = string3;
                if (string3 != null) break block3;
            }
            string = "";
        }
        String branch = string;
        return UtilsKt.runCommand("git clone " + GitsKt.gitUrl() + ' ' + tempPath.getPath() + branch + " --depth 1", new File("."), log);
    }

    public static /* synthetic */ String gitShallowClone$default(File file, String string, Log log, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        return GitsKt.gitShallowClone(file, string, log);
    }
}

