/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.deployment.helper;

import com.liferay.gradle.plugins.deployment.helper.BuildDeploymentHelperTask;
import com.liferay.gradle.util.GradleUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.bundling.Jar;

public class DeploymentHelperPlugin
implements Plugin<Project> {
    public static final String BUILD_DEPLOYMENT_HELPER_TASK_NAME = "buildDeploymentHelper";
    public static final String CONFIGURATION_NAME = "deploymentHelper";

    public void apply(Project project) {
        Configuration deploymentHelperConfiguration = this.addConfigurationDeploymentHelper(project);
        this.addTaskBuildDeploymentHelper(project);
        this.configureTasksBuildDeploymentHelper(project, deploymentHelperConfiguration);
    }

    protected Configuration addConfigurationDeploymentHelper(final Project project) {
        Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)CONFIGURATION_NAME);
        configuration.defaultDependencies((Action)new Action<DependencySet>(){

            public void execute(DependencySet dependencySet) {
                DeploymentHelperPlugin.this.addDependenciesDeploymentHelper(project);
            }
        });
        configuration.setDescription("Configures Liferay Deployment Helper for this project.");
        configuration.setVisible(false);
        return configuration;
    }

    protected void addDependenciesDeploymentHelper(Project project) {
        GradleUtil.addDependency((Project)project, (String)CONFIGURATION_NAME, (String)"com.liferay", (String)"com.liferay.deployment.helper", (String)"latest.release");
    }

    protected BuildDeploymentHelperTask addTaskBuildDeploymentHelper(final Project project) {
        BuildDeploymentHelperTask buildDeploymentHelperTask = (BuildDeploymentHelperTask)GradleUtil.addTask((Project)project, (String)BUILD_DEPLOYMENT_HELPER_TASK_NAME, BuildDeploymentHelperTask.class);
        buildDeploymentHelperTask.setDeploymentFiles(new Callable<List<Jar>>(){

            @Override
            public List<Jar> call() throws Exception {
                ArrayList<Jar> jarTasks = new ArrayList<Jar>();
                for (Project curProject : project.getAllprojects()) {
                    TaskContainer taskContainer = curProject.getTasks();
                    Task task = (Task)taskContainer.findByName("jar");
                    if (!(task instanceof Jar)) continue;
                    jarTasks.add((Jar)task);
                }
                return jarTasks;
            }
        });
        buildDeploymentHelperTask.setDescription("Assembles a war file to deploy one or more apps to a cluster.");
        buildDeploymentHelperTask.setGroup("build");
        buildDeploymentHelperTask.setOutputFile(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return new File(project.getBuildDir(), project.getName() + ".war");
            }
        });
        return buildDeploymentHelperTask;
    }

    protected void configureTaskBuildDeploymentHelperClasspath(BuildDeploymentHelperTask buildDeploymentHelperTask, FileCollection classpath) {
        buildDeploymentHelperTask.setClasspath(classpath);
    }

    protected void configureTasksBuildDeploymentHelper(Project project, final Configuration deploymentHelperConfiguration) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(BuildDeploymentHelperTask.class, (Action)new Action<BuildDeploymentHelperTask>(){

            public void execute(BuildDeploymentHelperTask buildDeploymentHelperTask) {
                DeploymentHelperPlugin.this.configureTaskBuildDeploymentHelperClasspath(buildDeploymentHelperTask, (FileCollection)deploymentHelperConfiguration);
            }
        });
    }
}

