/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.css.builder;

import com.liferay.gradle.plugins.css.builder.BuildCSSTask;
import com.liferay.gradle.util.GradleUtil;
import java.io.File;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.plugins.WarPlugin;
import org.gradle.api.plugins.WarPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskContainer;

public class CSSBuilderPlugin
implements Plugin<Project> {
    public static final String BUILD_CSS_TASK_NAME = "buildCSS";
    public static final String CSS_BUILDER_CONFIGURATION_NAME = "cssBuilder";
    public static final String PORTAL_COMMON_CSS_CONFIGURATION_NAME = "portalCommonCSS";

    public void apply(Project project) {
        Configuration cssBuilderConfiguration = this._addConfigurationCSSBuilder(project);
        Configuration portalCommonCSSConfiguration = this._addConfigurationPortalCommonCSS(project);
        this._addTaskBuildCSS(project);
        this._configureTasksBuildCSS(project, cssBuilderConfiguration, portalCommonCSSConfiguration);
    }

    private Configuration _addConfigurationCSSBuilder(final Project project) {
        Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)CSS_BUILDER_CONFIGURATION_NAME);
        configuration.defaultDependencies((Action)new Action<DependencySet>(){

            public void execute(DependencySet dependencySet) {
                CSSBuilderPlugin.this._addDependenciesCSSBuilder(project);
            }
        });
        configuration.setDescription("Configures Liferay CSS Builder for this project.");
        configuration.setVisible(false);
        return configuration;
    }

    private Configuration _addConfigurationPortalCommonCSS(final Project project) {
        Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)PORTAL_COMMON_CSS_CONFIGURATION_NAME);
        configuration.setDescription("Configures com.liferay.frontend.css.common for compiling CSS files.");
        configuration.setTransitive(false);
        configuration.setVisible(false);
        GradleUtil.executeIfEmpty((Configuration)configuration, (Action)new Action<Configuration>(){

            public void execute(Configuration configuration) {
                CSSBuilderPlugin.this._addDependenciesPortalCommonCSS(project);
            }
        });
        return configuration;
    }

    private void _addDependenciesCSSBuilder(Project project) {
        GradleUtil.addDependency((Project)project, (String)CSS_BUILDER_CONFIGURATION_NAME, (String)"com.liferay", (String)"com.liferay.css.builder", (String)"latest.release");
    }

    private void _addDependenciesPortalCommonCSS(Project project) {
        GradleUtil.addDependency((Project)project, (String)PORTAL_COMMON_CSS_CONFIGURATION_NAME, (String)"com.liferay", (String)"com.liferay.frontend.css.common", (String)"latest.release", (boolean)false);
        GradleUtil.addDependency((Project)project, (String)PORTAL_COMMON_CSS_CONFIGURATION_NAME, (String)"org.webjars", (String)"font-awesome", (String)"latest.release", (boolean)false);
    }

    private BuildCSSTask _addTaskBuildCSS(Project project) {
        final BuildCSSTask buildCSSTask = (BuildCSSTask)GradleUtil.addTask((Project)project, (String)BUILD_CSS_TASK_NAME, BuildCSSTask.class);
        buildCSSTask.setDescription("Build CSS files.");
        buildCSSTask.setGroup("build");
        PluginContainer pluginContainer = project.getPlugins();
        pluginContainer.withType(JavaPlugin.class, (Action)new Action<JavaPlugin>(){

            public void execute(JavaPlugin javaPlugin) {
                CSSBuilderPlugin.this._configureTaskBuildCSSForJavaPlugin(buildCSSTask);
            }
        });
        pluginContainer.withType(WarPlugin.class, (Action)new Action<WarPlugin>(){

            public void execute(WarPlugin warPlugin) {
                CSSBuilderPlugin.this._configureTaskBuildCSSForWarPlugin(buildCSSTask);
            }
        });
        return buildCSSTask;
    }

    private void _configureTaskBuildCSSClasspath(BuildCSSTask buildCSSTask, FileCollection classpath) {
        buildCSSTask.setClasspath(classpath);
    }

    private void _configureTaskBuildCSSForJavaPlugin(final BuildCSSTask buildCSSTask) {
        buildCSSTask.setBaseDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return CSSBuilderPlugin.this._getResourcesDir(buildCSSTask.getProject());
            }
        });
        Task processResourcesTask = GradleUtil.getTask((Project)buildCSSTask.getProject(), (String)"processResources");
        processResourcesTask.dependsOn(new Object[]{buildCSSTask});
    }

    private void _configureTaskBuildCSSForWarPlugin(final BuildCSSTask buildCSSTask) {
        buildCSSTask.setBaseDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return CSSBuilderPlugin.this._getWebAppDir(buildCSSTask.getProject());
            }
        });
    }

    private void _configureTaskBuildCSSImportFile(BuildCSSTask buildCSSTask, final Configuration portalCommonCSSConfiguration) {
        buildCSSTask.setImports(new Callable<FileCollection>(){

            @Override
            public FileCollection call() throws Exception {
                return portalCommonCSSConfiguration;
            }
        });
    }

    private void _configureTasksBuildCSS(Project project, final Configuration cssBuilderConfiguration, final Configuration portalCommonCSSConfiguration) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(BuildCSSTask.class, (Action)new Action<BuildCSSTask>(){

            public void execute(BuildCSSTask buildCSSTask) {
                CSSBuilderPlugin.this._configureTaskBuildCSSClasspath(buildCSSTask, (FileCollection)cssBuilderConfiguration);
                CSSBuilderPlugin.this._configureTaskBuildCSSImportFile(buildCSSTask, portalCommonCSSConfiguration);
            }
        });
    }

    private File _getResourcesDir(Project project) {
        SourceSet sourceSet = GradleUtil.getSourceSet((Project)project, (String)"main");
        return this._getSrcDir(sourceSet.getResources());
    }

    private File _getSrcDir(SourceDirectorySet sourceDirectorySet) {
        Set srcDirs = sourceDirectorySet.getSrcDirs();
        Iterator iterator = srcDirs.iterator();
        return (File)iterator.next();
    }

    private File _getWebAppDir(Project project) {
        WarPluginConvention warPluginConvention = (WarPluginConvention)GradleUtil.getConvention((Project)project, WarPluginConvention.class);
        return warPluginConvention.getWebAppDir();
    }
}

