/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.gradle;

import com.google.cloud.tools.jib.gradle.AuthParameters;
import com.google.cloud.tools.jib.gradle.PlatformParameters;
import com.google.cloud.tools.jib.gradle.PlatformParametersSpec;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;

public class BaseImageParameters {
    private final AuthParameters auth;
    @Nullable
    private String image;
    @Nullable
    private String credHelper;
    private final PlatformParametersSpec platformParametersSpec;
    private final ListProperty<PlatformParameters> platforms;

    @Inject
    public BaseImageParameters(ObjectFactory objectFactory) {
        this.auth = (AuthParameters)objectFactory.newInstance(AuthParameters.class, new Object[]{"from.auth"});
        this.platforms = objectFactory.listProperty(PlatformParameters.class);
        this.platformParametersSpec = (PlatformParametersSpec)objectFactory.newInstance(PlatformParametersSpec.class, new Object[]{objectFactory, this.platforms});
        PlatformParameters amd64Linux = new PlatformParameters();
        amd64Linux.setArchitecture("amd64");
        amd64Linux.setOs("linux");
        this.platforms.add((Object)amd64Linux);
    }

    @Nested
    @Optional
    public ListProperty<PlatformParameters> getPlatforms() {
        return this.platforms;
    }

    public void platforms(Action<? super PlatformParametersSpec> action) {
        this.platforms.empty();
        action.execute((Object)this.platformParametersSpec);
    }

    @Input
    @Nullable
    @Optional
    public String getImage() {
        if (System.getProperty("jib.from.image") != null) {
            return System.getProperty("jib.from.image");
        }
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    @Input
    @Nullable
    @Optional
    public String getCredHelper() {
        if (System.getProperty("jib.from.credHelper") != null) {
            return System.getProperty("jib.from.credHelper");
        }
        return this.credHelper;
    }

    public void setCredHelper(String credHelper) {
        this.credHelper = credHelper;
    }

    @Nested
    @Optional
    public AuthParameters getAuth() {
        return this.auth;
    }

    public void auth(Action<? super AuthParameters> action) {
        action.execute((Object)this.auth);
    }
}

