/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.registry;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.api.client.util.Base64;
import com.google.cloud.tools.jib.ProjectInfo;
import com.google.cloud.tools.jib.api.Credential;
import com.google.cloud.tools.jib.api.DescriptorDigest;
import com.google.cloud.tools.jib.api.LogEvent;
import com.google.cloud.tools.jib.api.RegistryAuthenticationFailedException;
import com.google.cloud.tools.jib.api.RegistryException;
import com.google.cloud.tools.jib.api.RegistryUnauthorizedException;
import com.google.cloud.tools.jib.blob.Blob;
import com.google.cloud.tools.jib.blob.BlobDescriptor;
import com.google.cloud.tools.jib.blob.Blobs;
import com.google.cloud.tools.jib.event.EventHandlers;
import com.google.cloud.tools.jib.global.JibSystemProperties;
import com.google.cloud.tools.jib.http.Authorization;
import com.google.cloud.tools.jib.http.FailoverHttpClient;
import com.google.cloud.tools.jib.image.json.BuildableManifestTemplate;
import com.google.cloud.tools.jib.image.json.ManifestTemplate;
import com.google.cloud.tools.jib.json.JsonTemplate;
import com.google.cloud.tools.jib.json.JsonTemplateMapper;
import com.google.cloud.tools.jib.registry.AuthenticationMethodRetriever;
import com.google.cloud.tools.jib.registry.BlobChecker;
import com.google.cloud.tools.jib.registry.BlobPuller;
import com.google.cloud.tools.jib.registry.ManifestAndDigest;
import com.google.cloud.tools.jib.registry.ManifestPuller;
import com.google.cloud.tools.jib.registry.ManifestPusher;
import com.google.cloud.tools.jib.registry.RegistryAuthenticator;
import com.google.cloud.tools.jib.registry.RegistryCredentialsNotSentException;
import com.google.cloud.tools.jib.registry.RegistryEndpointCaller;
import com.google.cloud.tools.jib.registry.RegistryEndpointProvider;
import com.google.cloud.tools.jib.registry.RegistryEndpointRequestProperties;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class RegistryClient {
    private static final int MAX_BEARER_TOKEN_REFRESH_TRIES = 5;
    private final EventHandlers eventHandlers;
    @Nullable
    private final Credential credential;
    private final RegistryEndpointRequestProperties registryEndpointRequestProperties;
    private final String userAgent;
    private final FailoverHttpClient httpClient;
    private final AtomicReference<Authorization> authorization = new AtomicReference();
    private boolean readOnlyBearerAuth;
    private final AtomicReference<RegistryAuthenticator> initialBearerAuthenticator = new AtomicReference();

    public static Factory factory(EventHandlers eventHandlers, String serverUrl, String imageName, FailoverHttpClient httpClient) {
        return new Factory(eventHandlers, new RegistryEndpointRequestProperties(serverUrl, imageName), httpClient);
    }

    public static Factory factory(EventHandlers eventHandlers, String serverUrl, String imageName, String sourceImageName, FailoverHttpClient httpClient) {
        return new Factory(eventHandlers, new RegistryEndpointRequestProperties(serverUrl, imageName, sourceImageName), httpClient);
    }

    @Nullable
    @VisibleForTesting
    static Multimap<String, String> decodeTokenRepositoryGrants(String token) {
        byte[] payloadData;
        String[] jwtParts = token.split("\\.", -1);
        if (jwtParts.length != 3 || (payloadData = Base64.decodeBase64((String)jwtParts[1])) == null) {
            return null;
        }
        try {
            TokenPayloadTemplate payload = JsonTemplateMapper.readJson(payloadData, TokenPayloadTemplate.class);
            if (payload.access == null) {
                return null;
            }
            return (Multimap)payload.access.stream().filter(claim -> "repository".equals(((AccessClaim)claim).type)).collect(ImmutableSetMultimap.flatteningToImmutableSetMultimap(claim -> ((AccessClaim)claim).name, claim -> ((AccessClaim)claim).actions == null ? Stream.empty() : ((AccessClaim)claim).actions.stream()));
        }
        catch (IOException ex) {
            return null;
        }
    }

    private RegistryClient(EventHandlers eventHandlers, @Nullable Credential credential, RegistryEndpointRequestProperties registryEndpointRequestProperties, String userAgent, FailoverHttpClient httpClient) {
        this.eventHandlers = eventHandlers;
        this.credential = credential;
        this.registryEndpointRequestProperties = registryEndpointRequestProperties;
        this.userAgent = userAgent;
        this.httpClient = httpClient;
    }

    public void configureBasicAuth() {
        Preconditions.checkNotNull((Object)this.credential);
        Preconditions.checkState((!this.credential.isOAuth2RefreshToken() ? 1 : 0) != 0);
        this.authorization.set(Authorization.fromBasicCredentials(this.credential.getUsername(), this.credential.getPassword()));
        String registry = this.registryEndpointRequestProperties.getServerUrl();
        String repository = this.registryEndpointRequestProperties.getImageName();
        this.eventHandlers.dispatch(LogEvent.debug("configured basic auth for " + registry + "/" + repository));
    }

    public boolean doPullBearerAuth() throws IOException, RegistryException {
        return this.doBearerAuth(true);
    }

    public boolean doPushBearerAuth() throws IOException, RegistryException {
        return this.doBearerAuth(false);
    }

    private boolean doBearerAuth(boolean readOnlyBearerAuth) throws IOException, RegistryException {
        String registry = this.registryEndpointRequestProperties.getServerUrl();
        String repository = this.registryEndpointRequestProperties.getImageName();
        String image = registry + "/" + repository;
        this.eventHandlers.dispatch(LogEvent.debug("attempting bearer auth for " + image + "..."));
        Optional<RegistryAuthenticator> authenticator = this.callRegistryEndpoint(new AuthenticationMethodRetriever(this.registryEndpointRequestProperties, this.getUserAgent(), this.httpClient));
        if (!authenticator.isPresent()) {
            this.eventHandlers.dispatch(LogEvent.debug("server requires basic auth for " + image));
            return false;
        }
        this.initialBearerAuthenticator.set(authenticator.get());
        if (readOnlyBearerAuth) {
            this.authorization.set(authenticator.get().authenticatePull(this.credential));
        } else {
            this.authorization.set(authenticator.get().authenticatePush(this.credential));
        }
        this.readOnlyBearerAuth = readOnlyBearerAuth;
        this.eventHandlers.dispatch(LogEvent.debug("bearer auth succeeded for " + image));
        return true;
    }

    private Authorization refreshBearerAuth(@Nullable String wwwAuthenticate) throws RegistryAuthenticationFailedException, RegistryCredentialsNotSentException {
        Optional<RegistryAuthenticator> authenticator;
        Preconditions.checkState((boolean)RegistryClient.isBearerAuth(this.authorization.get()));
        String registry = this.registryEndpointRequestProperties.getServerUrl();
        String repository = this.registryEndpointRequestProperties.getImageName();
        this.eventHandlers.dispatch(LogEvent.debug("refreshing bearer auth token for " + registry + "/" + repository + "..."));
        if (wwwAuthenticate != null && (authenticator = RegistryAuthenticator.fromAuthenticationMethod(wwwAuthenticate, this.registryEndpointRequestProperties, this.getUserAgent(), this.httpClient)).isPresent()) {
            if (this.readOnlyBearerAuth) {
                return authenticator.get().authenticatePull(this.credential);
            }
            return authenticator.get().authenticatePush(this.credential);
        }
        this.eventHandlers.dispatch(LogEvent.debug("server did not return 'WWW-Authenticate: Bearer' header. Actual: " + wwwAuthenticate));
        if (this.readOnlyBearerAuth) {
            return ((RegistryAuthenticator)Verify.verifyNotNull((Object)this.initialBearerAuthenticator.get())).authenticatePull(this.credential);
        }
        return ((RegistryAuthenticator)Verify.verifyNotNull((Object)this.initialBearerAuthenticator.get())).authenticatePush(this.credential);
    }

    public <T extends ManifestTemplate> ManifestAndDigest<T> pullManifest(String imageTag, Class<T> manifestTemplateClass) throws IOException, RegistryException {
        ManifestPuller<T> manifestPuller = new ManifestPuller<T>(this.registryEndpointRequestProperties, imageTag, manifestTemplateClass);
        return (ManifestAndDigest)this.callRegistryEndpoint(manifestPuller);
    }

    public ManifestAndDigest<?> pullManifest(String imageTag) throws IOException, RegistryException {
        return this.pullManifest(imageTag, ManifestTemplate.class);
    }

    public DescriptorDigest pushManifest(BuildableManifestTemplate manifestTemplate, String imageTag) throws IOException, RegistryException {
        if (RegistryClient.isBearerAuth(this.authorization.get()) && this.readOnlyBearerAuth) {
            throw new IllegalStateException("push may fail with pull-only bearer auth token");
        }
        return this.callRegistryEndpoint(new ManifestPusher(this.registryEndpointRequestProperties, manifestTemplate, imageTag, this.eventHandlers));
    }

    public Optional<BlobDescriptor> checkBlob(DescriptorDigest blobDigest) throws IOException, RegistryException {
        BlobChecker blobChecker = new BlobChecker(this.registryEndpointRequestProperties, blobDigest);
        return this.callRegistryEndpoint(blobChecker);
    }

    public Blob pullBlob(DescriptorDigest blobDigest, Consumer<Long> blobSizeListener, Consumer<Long> writtenByteCountListener) {
        return Blobs.from(outputStream -> {
            try {
                this.callRegistryEndpoint(new BlobPuller(this.registryEndpointRequestProperties, blobDigest, outputStream, blobSizeListener, writtenByteCountListener));
            }
            catch (RegistryException ex) {
                throw new IOException(ex);
            }
        });
    }

    /*
     * Exception decompiling
     */
    public boolean pushBlob(DescriptorDigest blobDigest, Blob blob, @Nullable String sourceRepository, Consumer<Long> writtenByteCountListener) throws IOException, RegistryException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @VisibleForTesting
    static boolean canAttemptBlobMount(@Nullable Authorization authorization, String repository) {
        if (!RegistryClient.isBearerAuth(authorization)) {
            return true;
        }
        Multimap<String, String> repositoryGrants = RegistryClient.decodeTokenRepositoryGrants(((Authorization)Verify.verifyNotNull((Object)authorization)).getToken());
        return repositoryGrants == null || repositoryGrants.containsEntry((Object)repository, (Object)"pull");
    }

    private static boolean isBearerAuth(@Nullable Authorization authorization) {
        return authorization != null && "bearer".equalsIgnoreCase(authorization.getScheme());
    }

    @VisibleForTesting
    String getUserAgent() {
        return this.userAgent;
    }

    private <T> T callRegistryEndpoint(RegistryEndpointProvider<T> registryEndpointProvider) throws IOException, RegistryException {
        int bearerTokenRefreshes = 0;
        while (true) {
            try {
                return new RegistryEndpointCaller<T>(this.eventHandlers, this.getUserAgent(), registryEndpointProvider, this.authorization.get(), this.registryEndpointRequestProperties, this.httpClient).call();
            }
            catch (RegistryUnauthorizedException ex) {
                if (ex.getHttpResponseException().getStatusCode() != 401 || !RegistryClient.isBearerAuth(this.authorization.get()) || ++bearerTokenRefreshes >= 5) {
                    throw ex;
                }
                String wwwAuthenticate = ex.getHttpResponseException().getHeaders().getAuthenticate();
                this.authorization.set(this.refreshBearerAuth(wwwAuthenticate));
                continue;
            }
            break;
        }
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class AccessClaim
    implements JsonTemplate {
        @Nullable
        private String type;
        @Nullable
        private String name;
        @Nullable
        private List<String> actions;

        private AccessClaim() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class TokenPayloadTemplate
    implements JsonTemplate {
        @Nullable
        private List<AccessClaim> access;

        private TokenPayloadTemplate() {
        }
    }

    public static class Factory {
        private final EventHandlers eventHandlers;
        private final RegistryEndpointRequestProperties registryEndpointRequestProperties;
        private final FailoverHttpClient httpClient;
        @Nullable
        private String userAgentSuffix;
        @Nullable
        private Credential credential;

        private Factory(EventHandlers eventHandlers, RegistryEndpointRequestProperties registryEndpointRequestProperties, FailoverHttpClient httpClient) {
            this.eventHandlers = eventHandlers;
            this.registryEndpointRequestProperties = registryEndpointRequestProperties;
            this.httpClient = httpClient;
        }

        public Factory setCredential(@Nullable Credential credential) {
            this.credential = credential;
            return this;
        }

        public Factory setUserAgentSuffix(@Nullable String userAgentSuffix) {
            this.userAgentSuffix = userAgentSuffix;
            return this;
        }

        public RegistryClient newRegistryClient() {
            return new RegistryClient(this.eventHandlers, this.credential, this.registryEndpointRequestProperties, this.makeUserAgent(), this.httpClient);
        }

        private String makeUserAgent() {
            if (!JibSystemProperties.isUserAgentEnabled()) {
                return "";
            }
            StringBuilder userAgentBuilder = new StringBuilder("jib ").append(ProjectInfo.VERSION);
            if (this.userAgentSuffix != null) {
                userAgentBuilder.append(" ").append(this.userAgentSuffix);
            }
            if (!Strings.isNullOrEmpty((String)System.getProperty("_JIB_UPSTREAM_CLIENT"))) {
                userAgentBuilder.append(" ").append(System.getProperty("_JIB_UPSTREAM_CLIENT"));
            }
            return userAgentBuilder.toString();
        }
    }
}

