/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.plugins.common;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.cloud.tools.jib.ProjectInfo;
import com.google.cloud.tools.jib.api.LogEvent;
import com.google.cloud.tools.jib.filesystem.XdgDirectories;
import com.google.cloud.tools.jib.http.FailoverHttpClient;
import com.google.cloud.tools.jib.http.Request;
import com.google.cloud.tools.jib.http.Response;
import com.google.cloud.tools.jib.json.JsonTemplate;
import com.google.cloud.tools.jib.json.JsonTemplateMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.base.Verify;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Consumer;

public class UpdateChecker {
    public static Future<Optional<String>> checkForUpdate(ExecutorService executorService, Consumer<LogEvent> log, String versionUrl, String toolName) {
        return executorService.submit(() -> UpdateChecker.performUpdateCheck(log, (String)Verify.verifyNotNull((Object)ProjectInfo.VERSION), versionUrl, UpdateChecker.getConfigDir(), toolName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    static Optional<String> performUpdateCheck(Consumer<LogEvent> log, String currentVersion, String versionUrl, Path configDir, String toolName) {
        if (Boolean.getBoolean("jib.disableUpdateChecks")) {
            return Optional.empty();
        }
        Path configFile = configDir.resolve("config.json");
        Path lastUpdateCheck = configDir.resolve("lastUpdateCheck");
        try {
            block30: {
                ConfigJsonTemplate config;
                if (Files.exists(configFile, new LinkOption[0]) && Files.size(configFile) > 0L) {
                    try {
                        config = JsonTemplateMapper.readJsonFromFile(configFile, ConfigJsonTemplate.class);
                        if (config.disableUpdateCheck) {
                            return Optional.empty();
                        }
                        break block30;
                    }
                    catch (IOException ex) {
                        log.accept(LogEvent.warn("Failed to read global Jib config; you may need to fix or delete " + configFile + ": " + ex.getMessage()));
                        return Optional.empty();
                    }
                }
                config = new ConfigJsonTemplate();
                Files.createDirectories(configDir, new FileAttribute[0]);
                try (OutputStream outputStream = Files.newOutputStream(configFile, new OpenOption[0]);){
                    JsonTemplateMapper.writeTo(config, outputStream);
                }
                catch (IOException ex) {
                    log.accept(LogEvent.debug("Failed to generate global Jib config; " + ex.getMessage()));
                    Files.deleteIfExists(configFile);
                }
            }
            if (Files.exists(lastUpdateCheck, new LinkOption[0])) {
                try {
                    String fileContents = new String(Files.readAllBytes(lastUpdateCheck), StandardCharsets.UTF_8);
                    Instant modifiedTime = Instant.parse(fileContents);
                    if (modifiedTime.plus(Duration.ofDays(1L)).isAfter(Instant.now())) {
                        return Optional.empty();
                    }
                }
                catch (IOException | DateTimeParseException ex) {
                    log.accept(LogEvent.debug("Failed to read lastUpdateCheck; " + ex.getMessage()));
                    Files.delete(lastUpdateCheck);
                }
            }
            FailoverHttpClient httpClient = new FailoverHttpClient(true, false, ignored -> {});
            try {
                Response response = httpClient.get(new URL(versionUrl), Request.builder().setHttpTimeout(3000).setUserAgent("jib " + currentVersion + " " + toolName).build());
                VersionJsonTemplate version = JsonTemplateMapper.readJson(response.getBody(), VersionJsonTemplate.class);
                Files.write(lastUpdateCheck, Instant.now().toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                if (currentVersion.equals(version.latest)) {
                    Optional<String> optional = Optional.empty();
                    return optional;
                }
                Optional<String> optional = Optional.of("A new version of Jib (" + version.latest + ") is available (currently using " + currentVersion + "). Update your build configuration to use the latest features and fixes!");
                return optional;
            }
            finally {
                httpClient.shutDown();
            }
        }
        catch (IOException ex) {
            log.accept(LogEvent.debug("Update check failed; " + ex.getMessage()));
            return Optional.empty();
        }
    }

    public static Optional<String> finishUpdateCheck(Future<Optional<String>> updateMessageFuture) {
        if (updateMessageFuture.isDone()) {
            try {
                return updateMessageFuture.get();
            }
            catch (InterruptedException | ExecutionException exception) {
                // empty catch block
            }
        }
        updateMessageFuture.cancel(true);
        return Optional.empty();
    }

    private static Path getConfigDir() {
        String configDirProperty = System.getProperty("jib.configDirectory");
        if (!Strings.isNullOrEmpty((String)configDirProperty)) {
            return Paths.get(configDirProperty, new String[0]);
        }
        return XdgDirectories.getConfigHome();
    }

    private UpdateChecker() {
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class VersionJsonTemplate
    implements JsonTemplate {
        private String latest = "";

        private VersionJsonTemplate() {
        }
    }

    @VisibleForTesting
    static class ConfigJsonTemplate
    implements JsonTemplate {
        private boolean disableUpdateCheck;

        ConfigJsonTemplate() {
        }

        @VisibleForTesting
        void setDisableUpdateCheck(boolean disableUpdateCheck) {
            this.disableUpdateCheck = disableUpdateCheck;
        }
    }
}

