/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.plugins.common;

import com.google.cloud.tools.jib.api.Credential;
import com.google.cloud.tools.jib.api.CredentialRetriever;
import com.google.cloud.tools.jib.frontend.CredentialRetrieverFactory;
import com.google.common.annotations.VisibleForTesting;
import java.io.FileNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nullable;

public class DefaultCredentialRetrievers {
    private static final Path DOCKER_CONFIG_FILE = Paths.get(".docker", "config.json");
    private static final Path KUBERNETES_DOCKER_CONFIG_FILE = Paths.get(".docker", ".dockerconfigjson");
    private static final Path LEGACY_DOCKER_CONFIG_FILE = Paths.get(".docker", ".dockercfg");
    private final CredentialRetrieverFactory credentialRetrieverFactory;
    @Nullable
    private CredentialRetriever knownCredentialRetriever;
    @Nullable
    private CredentialRetriever inferredCredentialRetriever;
    @Nullable
    private String credentialHelper;
    private final Properties systemProperties;
    private final Map<String, String> environment;

    public static DefaultCredentialRetrievers init(CredentialRetrieverFactory credentialRetrieverFactory) {
        return new DefaultCredentialRetrievers(credentialRetrieverFactory, System.getProperties(), System.getenv());
    }

    @VisibleForTesting
    DefaultCredentialRetrievers(CredentialRetrieverFactory credentialRetrieverFactory, Properties systemProperties, Map<String, String> environment) {
        this.credentialRetrieverFactory = credentialRetrieverFactory;
        this.systemProperties = systemProperties;
        this.environment = environment;
    }

    public DefaultCredentialRetrievers setKnownCredential(Credential knownCredential, String credentialSource) {
        this.knownCredentialRetriever = this.credentialRetrieverFactory.known(knownCredential, credentialSource);
        return this;
    }

    public DefaultCredentialRetrievers setInferredCredential(Credential inferredCredential, String credentialSource) {
        this.inferredCredentialRetriever = this.credentialRetrieverFactory.known(inferredCredential, credentialSource);
        return this;
    }

    public DefaultCredentialRetrievers setCredentialHelper(@Nullable String credentialHelper) {
        this.credentialHelper = credentialHelper;
        return this;
    }

    public List<CredentialRetriever> asList() throws FileNotFoundException {
        Path home;
        ArrayList<CredentialRetriever> credentialRetrievers = new ArrayList<CredentialRetriever>();
        if (this.knownCredentialRetriever != null) {
            credentialRetrievers.add(this.knownCredentialRetriever);
        }
        if (this.credentialHelper != null) {
            if (this.credentialHelper.contains(FileSystems.getDefault().getSeparator())) {
                if (!Files.exists(Paths.get(this.credentialHelper, new String[0]), new LinkOption[0])) {
                    throw new FileNotFoundException("Specified credential helper was not found: " + this.credentialHelper);
                }
                credentialRetrievers.add(this.credentialRetrieverFactory.dockerCredentialHelper(this.credentialHelper));
            } else {
                String suffix = this.credentialHelper;
                credentialRetrievers.add(this.credentialRetrieverFactory.dockerCredentialHelper("docker-credential-" + suffix));
            }
        }
        if (this.inferredCredentialRetriever != null) {
            credentialRetrievers.add(this.inferredCredentialRetriever);
        }
        String homeProperty = this.systemProperties.getProperty("user.home");
        String homeEnvVar = this.environment.get("HOME");
        if (homeProperty != null) {
            home = Paths.get(homeProperty, new String[0]);
            credentialRetrievers.add(this.credentialRetrieverFactory.dockerConfig(home.resolve(DOCKER_CONFIG_FILE)));
            credentialRetrievers.add(this.credentialRetrieverFactory.dockerConfig(home.resolve(KUBERNETES_DOCKER_CONFIG_FILE)));
            credentialRetrievers.add(this.credentialRetrieverFactory.legacyDockerConfig(home.resolve(LEGACY_DOCKER_CONFIG_FILE)));
        }
        if (homeEnvVar != null && !homeEnvVar.equals(homeProperty)) {
            home = Paths.get(homeEnvVar, new String[0]);
            credentialRetrievers.add(this.credentialRetrieverFactory.dockerConfig(home.resolve(DOCKER_CONFIG_FILE)));
            credentialRetrievers.add(this.credentialRetrieverFactory.dockerConfig(home.resolve(KUBERNETES_DOCKER_CONFIG_FILE)));
            credentialRetrievers.add(this.credentialRetrieverFactory.legacyDockerConfig(home.resolve(LEGACY_DOCKER_CONFIG_FILE)));
        }
        credentialRetrievers.add(this.credentialRetrieverFactory.wellKnownCredentialHelpers());
        credentialRetrievers.add(this.credentialRetrieverFactory.googleApplicationDefaultCredentials());
        return credentialRetrievers;
    }
}

