/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.gradle;

import com.google.cloud.tools.jib.plugins.common.ConfigurationPropertyValidator;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.Project;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;

public class ExtraDirectoriesParameters {
    private final Project project;
    private List<Path> paths;
    private Map<String, String> permissions = Collections.emptyMap();

    @Inject
    public ExtraDirectoriesParameters(Project project) {
        this.project = project;
        this.paths = Collections.singletonList(project.getProjectDir().toPath().resolve("src").resolve("main").resolve("jib"));
    }

    @Input
    public List<String> getPathStrings() {
        return this.getPaths().stream().map(Path::toString).collect(Collectors.toList());
    }

    @Internal
    public List<Path> getPaths() {
        String property = System.getProperty("jib.extraDirectories.paths");
        if (property != null) {
            List<String> pathStrings = ConfigurationPropertyValidator.parseListProperty(property);
            return pathStrings.stream().map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList());
        }
        return this.paths;
    }

    public void setPaths(Object paths) {
        this.paths = this.project.files(new Object[]{paths}).getFiles().stream().map(File::toPath).collect(Collectors.toList());
    }

    @Input
    public Map<String, String> getPermissions() {
        String property = System.getProperty("jib.extraDirectories.permissions");
        if (property != null) {
            return ConfigurationPropertyValidator.parseMapProperty(property);
        }
        return this.permissions;
    }

    public void setPermissions(Map<String, String> permissions) {
        this.permissions = permissions;
    }
}

