/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.api.LayerConfiguration;
import com.google.cloud.tools.jib.api.LogEvent;
import com.google.cloud.tools.jib.blob.Blob;
import com.google.cloud.tools.jib.builder.ProgressEventDispatcher;
import com.google.cloud.tools.jib.builder.TimerEventDispatcher;
import com.google.cloud.tools.jib.builder.steps.PreparedLayer;
import com.google.cloud.tools.jib.cache.Cache;
import com.google.cloud.tools.jib.cache.CacheCorruptedException;
import com.google.cloud.tools.jib.cache.CachedLayer;
import com.google.cloud.tools.jib.configuration.BuildContext;
import com.google.cloud.tools.jib.event.EventHandlers;
import com.google.cloud.tools.jib.image.ReproducibleLayerBuilder;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.Callable;

class BuildAndCacheApplicationLayerStep
implements Callable<PreparedLayer> {
    private static final String DESCRIPTION = "Building %s layer";
    private final BuildContext buildContext;
    private final ProgressEventDispatcher.Factory progressEventDispatcherFactory;
    private final String layerName;
    private final LayerConfiguration layerConfiguration;

    static ImmutableList<BuildAndCacheApplicationLayerStep> makeList(BuildContext buildContext, ProgressEventDispatcher.Factory progressEventDispatcherFactory) {
        ImmutableList<LayerConfiguration> layerConfigurations = buildContext.getLayerConfigurations();
        Throwable throwable = null;
        try (ProgressEventDispatcher progressEventDispatcher = progressEventDispatcherFactory.create("launching application layer builders", layerConfigurations.size());){
            ImmutableList immutableList;
            TimerEventDispatcher ignored = new TimerEventDispatcher(buildContext.getEventHandlers(), "Preparing application layer builders");
            Throwable throwable2 = null;
            try {
                immutableList = (ImmutableList)layerConfigurations.stream().filter(layerConfiguration -> !layerConfiguration.getLayerEntries().isEmpty()).map(layerConfiguration -> new BuildAndCacheApplicationLayerStep(buildContext, progressEventDispatcher.newChildProducer(), layerConfiguration.getName(), (LayerConfiguration)layerConfiguration)).collect(ImmutableList.toImmutableList());
            }
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        BuildAndCacheApplicationLayerStep.$closeResource(throwable2, ignored);
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            BuildAndCacheApplicationLayerStep.$closeResource(throwable2, ignored);
            return immutableList;
        }
    }

    private BuildAndCacheApplicationLayerStep(BuildContext buildContext, ProgressEventDispatcher.Factory progressEventDispatcherFactory, String layerName, LayerConfiguration layerConfiguration) {
        this.buildContext = buildContext;
        this.progressEventDispatcherFactory = progressEventDispatcherFactory;
        this.layerName = layerName;
        this.layerConfiguration = layerConfiguration;
    }

    @Override
    public PreparedLayer call() throws IOException, CacheCorruptedException {
        String description = String.format(DESCRIPTION, this.layerName);
        EventHandlers eventHandlers = this.buildContext.getEventHandlers();
        eventHandlers.dispatch(LogEvent.progress(description + "..."));
        Throwable throwable = null;
        try (ProgressEventDispatcher ignored = this.progressEventDispatcherFactory.create("building " + this.layerName + " layer", 1L);){
            PreparedLayer preparedLayer;
            Cache cache;
            Throwable throwable2;
            TimerEventDispatcher ignored2;
            block13: {
                ignored2 = new TimerEventDispatcher(eventHandlers, description);
                throwable2 = null;
                cache = this.buildContext.getApplicationLayersCache();
                Optional<CachedLayer> optionalCachedLayer = cache.retrieve(this.layerConfiguration.getLayerEntries());
                if (!optionalCachedLayer.isPresent()) break block13;
                PreparedLayer preparedLayer2 = new PreparedLayer.Builder(optionalCachedLayer.get()).setName(this.layerName).build();
                BuildAndCacheApplicationLayerStep.$closeResource(throwable2, ignored2);
                return preparedLayer2;
            }
            try {
                Blob layerBlob = new ReproducibleLayerBuilder(this.layerConfiguration.getLayerEntries()).build();
                CachedLayer cachedLayer = cache.writeUncompressedLayer(layerBlob, this.layerConfiguration.getLayerEntries());
                eventHandlers.dispatch(LogEvent.debug(description + " built " + cachedLayer.getDigest()));
                preparedLayer = new PreparedLayer.Builder(cachedLayer).setName(this.layerName).build();
            }
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        BuildAndCacheApplicationLayerStep.$closeResource(throwable2, ignored2);
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            BuildAndCacheApplicationLayerStep.$closeResource(throwable2, ignored2);
            return preparedLayer;
        }
    }
}

