/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.gradle;

import com.google.cloud.tools.jib.builder.BuildLogger;
import com.google.cloud.tools.jib.gradle.ContainerParameters;
import com.google.cloud.tools.jib.gradle.ImageConfiguration;
import com.google.cloud.tools.jib.image.ImageFormat;
import com.google.cloud.tools.jib.image.json.BuildableManifestTemplate;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.File;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;

public class JibExtension {
    private static final String DEFAULT_FROM_IMAGE = "gcr.io/distroless/java";
    private static final boolean DEFAULT_USE_ONLY_PROJECT_CACHE = false;
    private static final boolean DEFAULT_ALLOW_INSECURE_REGISTIRIES = false;
    private final ImageConfiguration from;
    private final ImageConfiguration to;
    private final ContainerParameters container;
    private final Property<Boolean> useOnlyProjectCache;
    private final Property<Boolean> allowInsecureRegistries;
    private final Property<File> extraDirectory;
    private final ListProperty<String> jvmFlags;
    private final Property<String> mainClass;
    private final ListProperty<String> args;
    private final Property<ImageFormat> format;

    private static Path resolveDefaultExtraDirectory(Path projectDirectory) {
        return projectDirectory.resolve("src").resolve("main").resolve("jib");
    }

    public JibExtension(Project project) {
        ObjectFactory objectFactory = project.getObjects();
        this.from = (ImageConfiguration)objectFactory.newInstance(ImageConfiguration.class, new Object[0]);
        this.to = (ImageConfiguration)objectFactory.newInstance(ImageConfiguration.class, new Object[0]);
        this.container = (ContainerParameters)objectFactory.newInstance(ContainerParameters.class, new Object[0]);
        this.jvmFlags = objectFactory.listProperty(String.class);
        this.mainClass = objectFactory.property(String.class);
        this.args = objectFactory.listProperty(String.class);
        this.format = objectFactory.property(ImageFormat.class);
        this.useOnlyProjectCache = objectFactory.property(Boolean.class);
        this.allowInsecureRegistries = objectFactory.property(Boolean.class);
        this.extraDirectory = objectFactory.property(File.class);
        this.from.setImage(DEFAULT_FROM_IMAGE);
        this.jvmFlags.set(Collections.emptyList());
        this.args.set(Collections.emptyList());
        this.useOnlyProjectCache.set((Object)false);
        this.allowInsecureRegistries.set((Object)false);
        this.extraDirectory.set((Object)JibExtension.resolveDefaultExtraDirectory(project.getProjectDir().toPath()).toFile());
    }

    void handleDeprecatedParameters(BuildLogger logger) {
        StringBuilder deprecatedParams = new StringBuilder();
        if (!((List)this.jvmFlags.get()).isEmpty()) {
            deprecatedParams.append("  jvmFlags -> container.jvmFlags\n");
            if (this.container.getJvmFlags().isEmpty()) {
                this.container.setJvmFlags((List)this.jvmFlags.get());
            }
        }
        if (!Strings.isNullOrEmpty((String)((String)this.mainClass.getOrNull()))) {
            deprecatedParams.append("  mainClass -> container.mainClass\n");
            if (Strings.isNullOrEmpty((String)this.container.getMainClass())) {
                this.container.setMainClass((String)this.mainClass.getOrNull());
            }
        }
        if (!((List)this.args.get()).isEmpty()) {
            deprecatedParams.append("  args -> container.args\n");
            if (this.container.getArgs().isEmpty()) {
                this.container.setArgs((List)this.args.get());
            }
        }
        if (this.format.getOrNull() != null) {
            deprecatedParams.append("  format -> container.format\n");
            this.container.setFormat((ImageFormat)((Object)this.format.get()));
        }
        if (deprecatedParams.length() > 0) {
            logger.warn("There are deprecated parameters used in the build configuration. Please make the following changes to your build.gradle to avoid issues in the future:\n" + deprecatedParams + "You may also wrap the parameters in a container{} block.");
        }
    }

    public void from(Action<? super ImageConfiguration> action) {
        action.execute((Object)this.from);
    }

    public void to(Action<? super ImageConfiguration> action) {
        action.execute((Object)this.to);
    }

    public void container(Action<? super ContainerParameters> action) {
        action.execute((Object)this.container);
    }

    public void setJvmFlags(List<String> jvmFlags) {
        this.jvmFlags.set(jvmFlags);
    }

    public void setMainClass(String mainClass) {
        this.mainClass.set((Object)mainClass);
    }

    public void setArgs(List<String> args) {
        this.args.set(args);
    }

    public void setFormat(ImageFormat format) {
        this.format.set((Object)format);
    }

    public void setUseOnlyProjectCache(boolean useOnlyProjectCache) {
        this.useOnlyProjectCache.set((Object)useOnlyProjectCache);
    }

    public void setAllowInsecureRegistries(boolean allowInsecureRegistries) {
        this.allowInsecureRegistries.set((Object)allowInsecureRegistries);
    }

    public void setExtraDirectory(File extraDirectory) {
        this.extraDirectory.set((Object)extraDirectory);
    }

    @Internal
    String getBaseImage() {
        return (String)Preconditions.checkNotNull((Object)this.from.getImage());
    }

    @Internal
    @Nullable
    String getTargetImage() {
        return this.to.getImage();
    }

    @Nested
    @Optional
    public ImageConfiguration getFrom() {
        return this.from;
    }

    @Nested
    @Optional
    public ImageConfiguration getTo() {
        return this.to;
    }

    @Nested
    @Optional
    public ContainerParameters getContainer() {
        return this.container;
    }

    @Input
    @Optional
    List<String> getJvmFlags() {
        return this.container.getJvmFlags();
    }

    @Input
    @Nullable
    @Optional
    String getMainClass() {
        return this.container.getMainClass();
    }

    @Input
    @Optional
    List<String> getArgs() {
        return this.container.getArgs();
    }

    @Input
    @Optional
    Class<? extends BuildableManifestTemplate> getFormat() {
        return this.container.getFormat();
    }

    @Internal
    @Optional
    List<String> getExposedPorts() {
        return this.container.getPorts();
    }

    @Input
    @Optional
    boolean getUseOnlyProjectCache() {
        return (Boolean)this.useOnlyProjectCache.get();
    }

    @Input
    @Optional
    boolean getAllowInsecureRegistries() {
        return (Boolean)this.allowInsecureRegistries.get();
    }

    @Input
    File getExtraDirectory() {
        return (File)this.extraDirectory.get();
    }
}

