/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.gradle;

import com.google.cloud.tools.jib.docker.DockerContextGenerator;
import com.google.cloud.tools.jib.frontend.ExposedPortsParser;
import com.google.cloud.tools.jib.gradle.GradleBuildLogger;
import com.google.cloud.tools.jib.gradle.GradleProjectProperties;
import com.google.cloud.tools.jib.gradle.HelpfulSuggestionsProvider;
import com.google.cloud.tools.jib.gradle.JibExtension;
import com.google.common.base.Preconditions;
import com.google.common.io.InsecureRecursiveDeleteException;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;

public class DockerContextTask
extends DefaultTask {
    @Nullable
    private String targetDir;
    @Nullable
    private JibExtension jibExtension;

    @Nested
    @Nullable
    public JibExtension getJib() {
        return this.jibExtension;
    }

    @InputFiles
    public FileCollection getInputFiles() {
        Task classesTask = this.getProject().getTasks().getByPath("classes");
        Set classesDependencies = classesTask.getTaskDependencies().getDependencies(classesTask);
        ArrayList<FileCollection> dependencyFileCollections = new ArrayList<FileCollection>();
        for (Task task : classesDependencies) {
            dependencyFileCollections.add(task.getOutputs().getFiles());
        }
        return this.getProject().files(new Object[]{dependencyFileCollections});
    }

    @OutputDirectory
    public String getOutputDirectory() {
        return this.getTargetDir();
    }

    @Input
    public String getTargetDir() {
        if (this.targetDir == null) {
            return this.getProject().getBuildDir().toPath().resolve("jib-docker-context").toString();
        }
        return this.targetDir;
    }

    @Option(option="targetDir", description="Directory to output the Docker context to")
    public void setTargetDir(String targetDir) {
        this.targetDir = targetDir;
    }

    @TaskAction
    public void generateDockerContext() {
        Preconditions.checkNotNull((Object)this.jibExtension);
        GradleBuildLogger gradleBuildLogger = new GradleBuildLogger(this.getLogger());
        this.jibExtension.handleDeprecatedParameters(gradleBuildLogger);
        GradleProjectProperties gradleProjectProperties = GradleProjectProperties.getForProject(this.getProject(), gradleBuildLogger);
        String mainClass = gradleProjectProperties.getMainClass(this.jibExtension);
        String targetDir = this.getTargetDir();
        try {
            ExposedPortsParser.parse(this.jibExtension.getExposedPorts());
            new DockerContextGenerator(gradleProjectProperties.getSourceFilesConfiguration()).setBaseImage(this.jibExtension.getBaseImage()).setJvmFlags(this.jibExtension.getJvmFlags()).setMainClass(mainClass).setJavaArguments(this.jibExtension.getArgs()).setExposedPorts(this.jibExtension.getExposedPorts()).generate(Paths.get(targetDir, new String[0]));
            gradleBuildLogger.lifecycle("Created Docker context at " + targetDir);
        }
        catch (InsecureRecursiveDeleteException ex) {
            throw new GradleException(HelpfulSuggestionsProvider.get("Export Docker context failed because cannot clear directory '" + this.getTargetDir() + "' safely").forDockerContextInsecureRecursiveDelete(this.getTargetDir()), (Throwable)ex);
        }
        catch (IOException ex) {
            throw new GradleException(HelpfulSuggestionsProvider.get("Export Docker context failed").suggest("check if the command-line option `--jib.dockerDir` is set correctly"), (Throwable)ex);
        }
    }

    DockerContextTask setJibExtension(JibExtension jibExtension) {
        this.jibExtension = jibExtension;
        return this;
    }
}

