/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.ncache;

import com.google.cloud.tools.jib.blob.Blob;
import com.google.cloud.tools.jib.image.DescriptorDigest;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
class CacheWrite {
    private final Blob layerBlob;
    @Nullable
    private final DescriptorDigest selector;
    @Nullable
    private final Blob metadataBlob;

    static CacheWrite layerOnly(Blob layerBlob) {
        return new CacheWrite(layerBlob, null, null);
    }

    static CacheWrite withSelectorAndMetadata(Blob layerBlob, DescriptorDigest selector, Blob metadataBlob) {
        return new CacheWrite(layerBlob, selector, metadataBlob);
    }

    private CacheWrite(Blob layerBlob, @Nullable DescriptorDigest selector, @Nullable Blob metadataBlob) {
        this.layerBlob = layerBlob;
        this.selector = selector;
        this.metadataBlob = metadataBlob;
    }

    Blob getLayerBlob() {
        return this.layerBlob;
    }

    Optional<DescriptorDigest> getSelector() {
        return Optional.ofNullable(this.selector);
    }

    Optional<Blob> getMetadataBlob() {
        return Optional.ofNullable(this.metadataBlob);
    }
}

