/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.gradle;

import com.google.cloud.tools.jib.JibLogger;
import com.google.cloud.tools.jib.configuration.BuildConfiguration;
import com.google.cloud.tools.jib.configuration.CacheConfiguration;
import com.google.cloud.tools.jib.configuration.ContainerConfiguration;
import com.google.cloud.tools.jib.configuration.ImageConfiguration;
import com.google.cloud.tools.jib.configuration.LayerConfiguration;
import com.google.cloud.tools.jib.configuration.Port;
import com.google.cloud.tools.jib.configuration.credentials.Credential;
import com.google.cloud.tools.jib.filesystem.AbsoluteUnixPath;
import com.google.cloud.tools.jib.frontend.CredentialRetrieverFactory;
import com.google.cloud.tools.jib.frontend.ExposedPortsParser;
import com.google.cloud.tools.jib.frontend.JavaEntrypointConstructor;
import com.google.cloud.tools.jib.global.JibSystemProperties;
import com.google.cloud.tools.jib.gradle.GradleJibLogger;
import com.google.cloud.tools.jib.gradle.GradleProjectProperties;
import com.google.cloud.tools.jib.gradle.JibExtension;
import com.google.cloud.tools.jib.image.ImageReference;
import com.google.cloud.tools.jib.image.InvalidImageReferenceException;
import com.google.cloud.tools.jib.plugins.common.ConfigurationPropertyValidator;
import com.google.cloud.tools.jib.plugins.common.DefaultCredentialRetrievers;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import org.gradle.api.GradleException;

class PluginConfigurationProcessor {
    private final BuildConfiguration.Builder buildConfigurationBuilder;
    private final ImageConfiguration.Builder baseImageConfigurationBuilder;
    private final ContainerConfiguration.Builder containerConfigurationBuilder;
    private final boolean isBaseImageCredentialPresent;

    static AbsoluteUnixPath getAppRootChecked(JibExtension jibExtension) {
        String appRoot = jibExtension.getContainer().getAppRoot();
        try {
            return AbsoluteUnixPath.get(appRoot);
        }
        catch (IllegalArgumentException ex) {
            throw new GradleException("container.appRoot is not an absolute Unix-style path: " + appRoot);
        }
    }

    static PluginConfigurationProcessor processCommonConfiguration(JibLogger logger, JibExtension jibExtension, GradleProjectProperties projectProperties) throws InvalidImageReferenceException, NumberFormatException {
        jibExtension.handleDeprecatedParameters(logger);
        JibSystemProperties.checkHttpTimeoutProperty();
        GradleJibLogger.disableHttpLogging();
        ImageReference baseImage = ImageReference.parse(jibExtension.getBaseImage());
        if (JibSystemProperties.isSendCredentialsOverHttpEnabled()) {
            logger.warn("Authentication over HTTP is enabled. It is strongly recommended that you do not enable this on a public network!");
        }
        DefaultCredentialRetrievers defaultCredentialRetrievers = DefaultCredentialRetrievers.init(CredentialRetrieverFactory.forImage(baseImage, logger));
        Optional<Credential> optionalFromCredential = ConfigurationPropertyValidator.getImageCredential(logger, "jib.from.auth.username", "jib.from.auth.password", jibExtension.getFrom().getAuth());
        optionalFromCredential.ifPresent(fromCredential -> defaultCredentialRetrievers.setKnownCredential((Credential)fromCredential, "jib.from.auth"));
        defaultCredentialRetrievers.setCredentialHelperSuffix(jibExtension.getFrom().getCredHelper());
        ImageConfiguration.Builder baseImageConfigurationBuilder = ImageConfiguration.builder(baseImage).setCredentialRetrievers(defaultCredentialRetrievers.asList());
        List<String> entrypoint = jibExtension.getContainer().getEntrypoint();
        if (entrypoint.isEmpty()) {
            String mainClass = projectProperties.getMainClass(jibExtension);
            entrypoint = JavaEntrypointConstructor.makeDefaultEntrypoint(PluginConfigurationProcessor.getAppRootChecked(jibExtension), jibExtension.getJvmFlags(), mainClass);
        } else if (jibExtension.getMainClass() != null || !jibExtension.getJvmFlags().isEmpty()) {
            logger.warn("mainClass and jvmFlags are ignored when entrypoint is specified");
        }
        ContainerConfiguration.Builder containerConfigurationBuilder = ContainerConfiguration.builder().setEntrypoint(entrypoint).setEnvironment(jibExtension.getEnvironment()).setProgramArguments(jibExtension.getArgs()).setExposedPorts((List<Port>)ExposedPortsParser.parse(jibExtension.getExposedPorts())).setLabels(jibExtension.getLabels());
        if (jibExtension.getUseCurrentTimestamp()) {
            logger.warn("Setting image creation time to current time; your image may not be reproducible.");
            containerConfigurationBuilder.setCreationTime(Instant.now());
        }
        BuildConfiguration.Builder buildConfigurationBuilder = BuildConfiguration.builder(logger).setToolName("jib-gradle-plugin").setEventEmitter(projectProperties.getEventEmitter()).setAllowInsecureRegistries(jibExtension.getAllowInsecureRegistries()).setLayerConfigurations((List<LayerConfiguration>)projectProperties.getJavaLayerConfigurations().getLayerConfigurations());
        CacheConfiguration applicationLayersCacheConfiguration = CacheConfiguration.forPath(projectProperties.getCacheDirectory());
        buildConfigurationBuilder.setApplicationLayersCacheConfiguration(applicationLayersCacheConfiguration);
        if (jibExtension.getUseOnlyProjectCache()) {
            buildConfigurationBuilder.setBaseImageLayersCacheConfiguration(applicationLayersCacheConfiguration);
        }
        return new PluginConfigurationProcessor(buildConfigurationBuilder, baseImageConfigurationBuilder, containerConfigurationBuilder, optionalFromCredential.isPresent());
    }

    private PluginConfigurationProcessor(BuildConfiguration.Builder buildConfigurationBuilder, ImageConfiguration.Builder baseImageConfigurationBuilder, ContainerConfiguration.Builder containerConfigurationBuilder, boolean isBaseImageCredentialPresent) {
        this.buildConfigurationBuilder = buildConfigurationBuilder;
        this.baseImageConfigurationBuilder = baseImageConfigurationBuilder;
        this.containerConfigurationBuilder = containerConfigurationBuilder;
        this.isBaseImageCredentialPresent = isBaseImageCredentialPresent;
    }

    BuildConfiguration.Builder getBuildConfigurationBuilder() {
        return this.buildConfigurationBuilder;
    }

    ImageConfiguration.Builder getBaseImageConfigurationBuilder() {
        return this.baseImageConfigurationBuilder;
    }

    ContainerConfiguration.Builder getContainerConfigurationBuilder() {
        return this.containerConfigurationBuilder;
    }

    boolean isBaseImageCredentialPresent() {
        return this.isBaseImageCredentialPresent;
    }
}

