/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.gradle;

import com.google.api.client.http.HttpTransport;
import com.google.cloud.tools.jib.JibLogger;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gradle.internal.logging.events.LogEvent;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.logging.slf4j.OutputEventListenerBackedLoggerContext;
import org.slf4j.LoggerFactory;

class GradleJibLogger
implements JibLogger {
    private static final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private final org.gradle.api.logging.Logger logger;

    static void disableHttpLogging() {
        OutputEventListenerBackedLoggerContext context = (OutputEventListenerBackedLoggerContext)LoggerFactory.getILoggerFactory();
        OutputEventListener defaultOutputEventListener = context.getOutputEventListener();
        context.setOutputEventListener(event -> {
            LogEvent logEvent = (LogEvent)event;
            if (!logEvent.getCategory().contains("org.apache")) {
                defaultOutputEventListener.onOutput(event);
            }
        });
        Logger.getLogger(HttpTransport.class.getName()).setLevel(Level.OFF);
    }

    GradleJibLogger(org.gradle.api.logging.Logger logger) {
        this.logger = logger;
    }

    @Override
    public void lifecycle(CharSequence message) {
        executorService.submit(() -> this.logger.lifecycle(message.toString()));
    }

    @Override
    public void debug(CharSequence message) {
        executorService.submit(() -> this.logger.debug(message.toString()));
    }

    @Override
    public void info(CharSequence message) {
        executorService.submit(() -> this.logger.info(message.toString()));
    }

    @Override
    public void warn(CharSequence message) {
        executorService.submit(() -> this.logger.warn("warning: " + message));
    }

    @Override
    public void error(CharSequence message) {
        executorService.submit(() -> this.logger.error(message.toString()));
    }
}

