/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.gradle;

import com.google.cloud.tools.jib.gradle.JibExtension;
import com.google.common.base.Preconditions;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskAction;

public class FilesTask
extends DefaultTask {
    @Nullable
    private JibExtension jibExtension;

    private static void printGradleFiles(Project project) {
        Path projectPath = project.getProjectDir().toPath();
        System.out.println(project.getBuildFile());
        if (project.getGradle().getStartParameter().getSettingsFile() != null) {
            System.out.println(project.getGradle().getStartParameter().getSettingsFile());
        } else if (Files.exists(projectPath.resolve("settings.gradle"), new LinkOption[0])) {
            System.out.println(projectPath.resolve("settings.gradle"));
        }
        if (Files.exists(projectPath.resolve("gradle.properties"), new LinkOption[0])) {
            System.out.println(projectPath.resolve("gradle.properties"));
        }
    }

    private static void printProjectFiles(Project project) {
        JavaPluginConvention javaConvention = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
        SourceSet mainSourceSet = (SourceSet)javaConvention.getSourceSets().findByName("main");
        if (mainSourceSet == null) {
            return;
        }
        FilesTask.printGradleFiles(project);
        mainSourceSet.getAllSource().getSourceDirectories().forEach(sourceDirectory -> {
            if (sourceDirectory.exists()) {
                System.out.println(sourceDirectory);
            }
        });
    }

    private static void findProjectDependencies(Project project, Set<ProjectDependency> projectDependenciesResult) {
        for (Configuration configuration : project.getConfigurations().getByName("runtime").getHierarchy()) {
            for (Dependency dependency : configuration.getDependencies()) {
                if (!(dependency instanceof ProjectDependency)) continue;
                projectDependenciesResult.add((ProjectDependency)dependency);
                FilesTask.findProjectDependencies(((ProjectDependency)dependency).getDependencyProject(), projectDependenciesResult);
            }
        }
    }

    public FilesTask setJibExtension(JibExtension jibExtension) {
        this.jibExtension = jibExtension;
        return this;
    }

    @TaskAction
    public void listFiles() {
        Preconditions.checkNotNull((Object)this.jibExtension);
        Project project = this.getProject();
        if (project != project.getRootProject()) {
            FilesTask.printGradleFiles(project.getRootProject());
        }
        FilesTask.printProjectFiles(project);
        if (Files.exists(this.jibExtension.getExtraDirectoryPath(), new LinkOption[0])) {
            System.out.println(this.jibExtension.getExtraDirectoryPath());
        }
        HashSet<ProjectDependency> projectDependencies = new HashSet<ProjectDependency>();
        FilesTask.findProjectDependencies(project, projectDependencies);
        HashSet<File> projectDependencyJars = new HashSet<File>();
        for (ProjectDependency projectDependency : projectDependencies) {
            FilesTask.printProjectFiles(projectDependency.getDependencyProject());
            String configurationName = projectDependency.getTargetConfiguration();
            if (configurationName == null) {
                configurationName = "default";
            }
            Project dependencyProject = projectDependency.getDependencyProject();
            for (Configuration targetConfiguration : dependencyProject.getConfigurations().getByName(configurationName).getHierarchy()) {
                for (PublishArtifact artifact : targetConfiguration.getArtifacts()) {
                    projectDependencyJars.add(artifact.getFile());
                }
            }
        }
        for (File file : project.getConfigurations().getByName("runtime")) {
            if (projectDependencyJars.contains(file) || !file.toString().contains("SNAPSHOT")) continue;
            System.out.println(file);
            projectDependencyJars.add(file);
        }
    }
}

