/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.gradle;

import com.google.cloud.tools.jib.cache.CacheDirectoryCreationException;
import com.google.cloud.tools.jib.configuration.BuildConfiguration;
import com.google.cloud.tools.jib.configuration.ImageConfiguration;
import com.google.cloud.tools.jib.configuration.credentials.Credential;
import com.google.cloud.tools.jib.filesystem.AbsoluteUnixPath;
import com.google.cloud.tools.jib.frontend.CredentialRetrieverFactory;
import com.google.cloud.tools.jib.gradle.GradleHelpfulSuggestionsBuilder;
import com.google.cloud.tools.jib.gradle.GradleJibLogger;
import com.google.cloud.tools.jib.gradle.GradleProjectProperties;
import com.google.cloud.tools.jib.gradle.JibExtension;
import com.google.cloud.tools.jib.gradle.JibTask;
import com.google.cloud.tools.jib.gradle.PluginConfigurationProcessor;
import com.google.cloud.tools.jib.image.ImageReference;
import com.google.cloud.tools.jib.image.InvalidImageReferenceException;
import com.google.cloud.tools.jib.plugins.common.BuildStepsExecutionException;
import com.google.cloud.tools.jib.plugins.common.BuildStepsRunner;
import com.google.cloud.tools.jib.plugins.common.ConfigurationPropertyValidator;
import com.google.cloud.tools.jib.plugins.common.DefaultCredentialRetrievers;
import com.google.cloud.tools.jib.plugins.common.HelpfulSuggestions;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Optional;
import javax.annotation.Nullable;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;

public class BuildImageTask
extends DefaultTask
implements JibTask {
    private static final String HELPFUL_SUGGESTIONS_PREFIX = "Build image failed";
    @Nullable
    private JibExtension jibExtension;

    @Nested
    @Nullable
    public JibExtension getJib() {
        return this.jibExtension;
    }

    @Option(option="image", description="The image reference for the target image")
    public void setTargetImage(String targetImage) {
        ((JibExtension)Preconditions.checkNotNull((Object)this.jibExtension)).getTo().setImage(targetImage);
    }

    @TaskAction
    public void buildImage() throws InvalidImageReferenceException {
        Preconditions.checkNotNull((Object)this.jibExtension);
        GradleJibLogger gradleJibLogger = new GradleJibLogger(this.getLogger());
        AbsoluteUnixPath appRoot = PluginConfigurationProcessor.getAppRootChecked(this.jibExtension);
        GradleProjectProperties gradleProjectProperties = GradleProjectProperties.getForProject(this.getProject(), this.getLogger(), this.jibExtension.getExtraDirectoryPath(), appRoot);
        if (Strings.isNullOrEmpty((String)this.jibExtension.getTargetImage())) {
            throw new GradleException(HelpfulSuggestions.forToNotConfigured("Missing target image parameter", "'jib.to.image'", "build.gradle", "gradle jib --image <your image name>"));
        }
        ImageReference targetImage = ImageReference.parse(this.jibExtension.getTargetImage());
        DefaultCredentialRetrievers defaultCredentialRetrievers = DefaultCredentialRetrievers.init(CredentialRetrieverFactory.forImage(targetImage, gradleJibLogger));
        Optional<Credential> optionalToCredential = ConfigurationPropertyValidator.getImageCredential(gradleJibLogger, "jib.to.auth.username", "jib.to.auth.password", this.jibExtension.getTo().getAuth());
        optionalToCredential.ifPresent(toCredential -> defaultCredentialRetrievers.setKnownCredential((Credential)toCredential, "jib.to.auth"));
        defaultCredentialRetrievers.setCredentialHelperSuffix(this.jibExtension.getTo().getCredHelper());
        ImageConfiguration targetImageConfiguration = ImageConfiguration.builder(targetImage).setCredentialRetrievers(defaultCredentialRetrievers.asList()).build();
        PluginConfigurationProcessor pluginConfigurationProcessor = PluginConfigurationProcessor.processCommonConfiguration(gradleJibLogger, this.jibExtension, gradleProjectProperties);
        BuildConfiguration buildConfiguration = pluginConfigurationProcessor.getBuildConfigurationBuilder().setBaseImageConfiguration(pluginConfigurationProcessor.getBaseImageConfigurationBuilder().build()).setTargetImageConfiguration(targetImageConfiguration).setAdditionalTargetImageTags(this.jibExtension.getTo().getTags()).setContainerConfiguration(pluginConfigurationProcessor.getContainerConfigurationBuilder().build()).setTargetFormat(this.jibExtension.getFormat()).build();
        HelpfulSuggestions helpfulSuggestions = new GradleHelpfulSuggestionsBuilder(HELPFUL_SUGGESTIONS_PREFIX, this.jibExtension).setBaseImageReference(buildConfiguration.getBaseImageConfiguration().getImage()).setBaseImageHasConfiguredCredentials(pluginConfigurationProcessor.isBaseImageCredentialPresent()).setTargetImageReference(buildConfiguration.getTargetImageConfiguration().getImage()).setTargetImageHasConfiguredCredentials(optionalToCredential.isPresent()).build();
        try {
            BuildStepsRunner.forBuildImage(buildConfiguration).build(helpfulSuggestions);
        }
        catch (CacheDirectoryCreationException | BuildStepsExecutionException ex) {
            throw new GradleException(ex.getMessage(), ex.getCause());
        }
    }

    @Override
    public BuildImageTask setJibExtension(JibExtension jibExtension) {
        this.jibExtension = jibExtension;
        return this;
    }
}

