/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.plugins.common;

import com.google.cloud.tools.jib.configuration.FilePermissions;
import com.google.cloud.tools.jib.filesystem.AbsoluteUnixPath;
import com.google.cloud.tools.jib.frontend.JavaLayerConfigurations;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.function.Predicate;

public class JavaLayerConfigurationsHelper {
    public static JavaLayerConfigurations fromExplodedWar(Path explodedWar, AbsoluteUnixPath appRoot, Path extraFilesDirectory, Map<AbsoluteUnixPath, FilePermissions> extraDirectoryPermissions) throws IOException {
        Path webInfLib = explodedWar.resolve("WEB-INF/lib");
        Path webInfClasses = explodedWar.resolve("WEB-INF/classes");
        Predicate<Path> nameHasSnapshot = path -> path.getFileName().toString().contains("SNAPSHOT");
        Predicate<Path> isSnapshotDependency = path -> path.startsWith(webInfLib) && nameHasSnapshot.test((Path)path);
        Predicate<Path> isNonSnapshotDependency = path -> path.startsWith(webInfLib) && !nameHasSnapshot.test((Path)path);
        Predicate<Path> isClassFile = path -> path.startsWith(webInfClasses) && path.getFileName().toString().endsWith(".class");
        Predicate<Path> isResource = isSnapshotDependency.or(isNonSnapshotDependency).or(isClassFile).negate();
        JavaLayerConfigurations.Builder layerBuilder = JavaLayerConfigurations.builder();
        if (Files.exists(webInfLib, new LinkOption[0])) {
            AbsoluteUnixPath basePathInContainer = appRoot.resolve("WEB-INF/lib");
            layerBuilder.addDirectoryContents(JavaLayerConfigurations.LayerType.DEPENDENCIES, webInfLib, isNonSnapshotDependency, basePathInContainer);
            layerBuilder.addDirectoryContents(JavaLayerConfigurations.LayerType.SNAPSHOT_DEPENDENCIES, webInfLib, isSnapshotDependency, basePathInContainer);
        }
        if (Files.exists(webInfClasses, new LinkOption[0])) {
            layerBuilder.addDirectoryContents(JavaLayerConfigurations.LayerType.CLASSES, webInfClasses, isClassFile, appRoot.resolve("WEB-INF/classes"));
        }
        layerBuilder.addDirectoryContents(JavaLayerConfigurations.LayerType.RESOURCES, explodedWar, isResource, appRoot);
        if (Files.exists(extraFilesDirectory, new LinkOption[0])) {
            layerBuilder.addDirectoryContents(JavaLayerConfigurations.LayerType.EXTRA_FILES, extraFilesDirectory, path -> true, AbsoluteUnixPath.get("/"), extraDirectoryPermissions);
        }
        return layerBuilder.build();
    }

    private JavaLayerConfigurationsHelper() {
    }
}

