/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.gradle;

import com.google.cloud.tools.jib.gradle.JibExtension;
import com.google.cloud.tools.jib.image.ImageReference;
import com.google.cloud.tools.jib.plugins.common.HelpfulSuggestions;
import javax.annotation.Nullable;

class GradleHelpfulSuggestionsBuilder {
    private final String messagePrefix;
    private final JibExtension jibExtension;
    @Nullable
    private ImageReference baseImageReference;
    @Nullable
    private ImageReference targetImageReference;
    private boolean baseImageHasConfiguredCredentials;
    private boolean targetImageHasConfiguredCredentials;

    GradleHelpfulSuggestionsBuilder(String messagePrefix, JibExtension jibExtension) {
        this.messagePrefix = messagePrefix;
        this.jibExtension = jibExtension;
    }

    GradleHelpfulSuggestionsBuilder setBaseImageReference(ImageReference baseImageReference) {
        this.baseImageReference = baseImageReference;
        return this;
    }

    GradleHelpfulSuggestionsBuilder setBaseImageHasConfiguredCredentials(boolean areKnownCredentialsDefined) {
        this.baseImageHasConfiguredCredentials = areKnownCredentialsDefined;
        return this;
    }

    GradleHelpfulSuggestionsBuilder setTargetImageReference(ImageReference targetImageReference) {
        this.targetImageReference = targetImageReference;
        return this;
    }

    GradleHelpfulSuggestionsBuilder setTargetImageHasConfiguredCredentials(boolean areKnownCredentialsDefined) {
        this.targetImageHasConfiguredCredentials = areKnownCredentialsDefined;
        return this;
    }

    HelpfulSuggestions build() {
        boolean isCredHelperDefinedForBaseImage = this.jibExtension.getFrom().getCredHelper() != null;
        boolean isCredHelperDefinedForTargetImage = this.jibExtension.getTo().getCredHelper() != null;
        return new HelpfulSuggestions(this.messagePrefix, "gradle clean", this.baseImageReference, !isCredHelperDefinedForBaseImage && !this.baseImageHasConfiguredCredentials, "from.credHelper", ignored -> "from.auth", this.targetImageReference, !isCredHelperDefinedForTargetImage && !this.targetImageHasConfiguredCredentials, "to.credHelper", ignored -> "to.auth", "jib.to.image", "--image", "build.gradle");
    }
}

