/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.gradle;

import com.google.cloud.tools.jib.configuration.CacheDirectoryCreationException;
import com.google.cloud.tools.jib.configuration.LayerConfiguration;
import com.google.cloud.tools.jib.event.DefaultEventDispatcher;
import com.google.cloud.tools.jib.filesystem.AbsoluteUnixPath;
import com.google.cloud.tools.jib.gradle.GradleHelpfulSuggestionsBuilder;
import com.google.cloud.tools.jib.gradle.GradleProjectProperties;
import com.google.cloud.tools.jib.gradle.GradleRawConfiguration;
import com.google.cloud.tools.jib.gradle.JibExtension;
import com.google.cloud.tools.jib.gradle.JibTask;
import com.google.cloud.tools.jib.gradle.TaskCommon;
import com.google.cloud.tools.jib.image.InvalidImageReferenceException;
import com.google.cloud.tools.jib.plugins.common.AppRootInvalidException;
import com.google.cloud.tools.jib.plugins.common.BuildStepsExecutionException;
import com.google.cloud.tools.jib.plugins.common.BuildStepsRunner;
import com.google.cloud.tools.jib.plugins.common.HelpfulSuggestions;
import com.google.cloud.tools.jib.plugins.common.InferredAuthRetrievalException;
import com.google.cloud.tools.jib.plugins.common.MainClassInferenceException;
import com.google.cloud.tools.jib.plugins.common.PluginConfigurationProcessor;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;

public class BuildTarTask
extends DefaultTask
implements JibTask {
    private static final String HELPFUL_SUGGESTIONS_PREFIX = "Building image tarball failed";
    @Nullable
    private JibExtension jibExtension;

    @Nested
    @Nullable
    public JibExtension getJib() {
        return this.jibExtension;
    }

    @Option(option="image", description="The image reference for the target image")
    public void setTargetImage(String targetImage) {
        ((JibExtension)Preconditions.checkNotNull((Object)this.jibExtension)).getTo().setImage(targetImage);
    }

    @InputFiles
    public FileCollection getInputFiles() {
        return GradleProjectProperties.getInputFiles(((JibExtension)Preconditions.checkNotNull((Object)this.jibExtension)).getExtraDirectory().getPath().toFile(), this.getProject());
    }

    @OutputFile
    public String getOutputFile() {
        return this.getTargetPath().toString();
    }

    @TaskAction
    public void buildTar() throws InvalidImageReferenceException, BuildStepsExecutionException, IOException, CacheDirectoryCreationException, MainClassInferenceException, InferredAuthRetrievalException {
        Preconditions.checkNotNull((Object)this.jibExtension);
        TaskCommon.disableHttpLogging();
        try {
            AbsoluteUnixPath appRoot = TaskCommon.getAppRootChecked(this.jibExtension, this.getProject());
            GradleProjectProperties projectProperties = GradleProjectProperties.getForProject(this.getProject(), this.getLogger(), this.jibExtension.getExtraDirectory().getPath(), this.jibExtension.getExtraDirectory().getPermissions(), appRoot);
            GradleRawConfiguration rawConfiguration = new GradleRawConfiguration(this.jibExtension);
            GradleHelpfulSuggestionsBuilder gradleHelpfulSuggestionsBuilder = new GradleHelpfulSuggestionsBuilder(HELPFUL_SUGGESTIONS_PREFIX, this.jibExtension);
            Path tarOutputPath = this.getTargetPath();
            PluginConfigurationProcessor pluginConfigurationProcessor = PluginConfigurationProcessor.processCommonConfigurationForTarImage(rawConfiguration, projectProperties, tarOutputPath, gradleHelpfulSuggestionsBuilder.build());
            HelpfulSuggestions helpfulSuggestions = gradleHelpfulSuggestionsBuilder.setBaseImageReference(pluginConfigurationProcessor.getBaseImageReference()).setBaseImageHasConfiguredCredentials(pluginConfigurationProcessor.isBaseImageCredentialPresent()).setTargetImageReference(pluginConfigurationProcessor.getTargetImageReference()).build();
            Path buildOutput = this.getProject().getBuildDir().toPath();
            BuildStepsRunner.forBuildTar(tarOutputPath).writeImageDigest(buildOutput.resolve("jib-image.digest")).build(pluginConfigurationProcessor.getJibContainerBuilder(), pluginConfigurationProcessor.getContainerizer(), new DefaultEventDispatcher(projectProperties.getEventHandlers()), (List<LayerConfiguration>)projectProperties.getJavaLayerConfigurations().getLayerConfigurations(), helpfulSuggestions);
        }
        catch (AppRootInvalidException ex) {
            throw new GradleException("container.appRoot is not an absolute Unix-style path: " + ex.getInvalidAppRoot());
        }
    }

    @Override
    public BuildTarTask setJibExtension(JibExtension jibExtension) {
        this.jibExtension = jibExtension;
        return this;
    }

    private Path getTargetPath() {
        return this.getProject().getBuildDir().toPath().resolve("jib-image.tar");
    }
}

