/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.frontend;

import com.google.cloud.tools.jib.event.EventDispatcher;
import com.google.cloud.tools.jib.event.events.LogEvent;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;

public class MainClassFinder {
    private final ImmutableList<Path> files;
    private final EventDispatcher eventDispatcher;

    public MainClassFinder(ImmutableList<Path> files, EventDispatcher eventDispatcher) {
        this.files = files;
        this.eventDispatcher = eventDispatcher;
    }

    public Result find() {
        ArrayList mainClasses = new ArrayList();
        for (Path file : this.files) {
            this.findMainClass(file).ifPresent(mainClasses::add);
        }
        if (mainClasses.size() == 1) {
            return Result.success((String)mainClasses.get(0));
        }
        if (mainClasses.size() == 0) {
            return Result.mainClassNotFound();
        }
        return Result.multipleMainClasses(mainClasses);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<String> findMainClass(Path file) {
        if (!Files.exists(file, new LinkOption[0])) return Optional.empty();
        if (!Files.isRegularFile(file, new LinkOption[0])) return Optional.empty();
        if (!file.toString().endsWith(".class")) {
            return Optional.empty();
        }
        ClassPool classPool = new ClassPool();
        classPool.appendSystemPath();
        try {
            CtClass[] mainMethodParams = new CtClass[]{classPool.get("java.lang.String[]")};
            try (InputStream classFileInputStream2 = Files.newInputStream(file, new OpenOption[0]);){
                CtClass fileClass = classPool.makeClass(classFileInputStream2);
                CtMethod mainMethod = fileClass.getDeclaredMethod("main", mainMethodParams);
                if (!CtClass.voidType.equals(mainMethod.getReturnType())) return Optional.empty();
                if (!Modifier.isStatic(mainMethod.getModifiers())) return Optional.empty();
                if (!Modifier.isPublic(mainMethod.getModifiers())) return Optional.empty();
                Optional<String> optional = Optional.of(fileClass.getName());
                return optional;
            }
            catch (NotFoundException classFileInputStream2) {
                return Optional.empty();
            }
            catch (IOException ex) {
                this.eventDispatcher.dispatch(LogEvent.warn("Could not read file: " + file));
                return Optional.empty();
            }
        }
        catch (NotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static class Result {
        private final Type type;
        private final List<String> foundMainClasses;

        private static Result success(String foundMainClass) {
            return new Result(Type.MAIN_CLASS_FOUND, Collections.singletonList(foundMainClass));
        }

        private static Result mainClassNotFound() {
            return new Result(Type.MAIN_CLASS_NOT_FOUND, Collections.emptyList());
        }

        private static Result multipleMainClasses(List<String> foundMainClasses) {
            return new Result(Type.MULTIPLE_MAIN_CLASSES, foundMainClasses);
        }

        private Result(Type type, List<String> foundMainClasses) {
            this.foundMainClasses = foundMainClasses;
            this.type = type;
        }

        public String getFoundMainClass() {
            Preconditions.checkState((Type.MAIN_CLASS_FOUND == this.type ? 1 : 0) != 0);
            Preconditions.checkState((this.foundMainClasses.size() == 1 ? 1 : 0) != 0);
            return this.foundMainClasses.get(0);
        }

        public Type getType() {
            return (Type)((Object)Preconditions.checkNotNull((Object)((Object)this.type)));
        }

        public List<String> getFoundMainClasses() {
            return this.foundMainClasses;
        }

        public static enum Type {
            MAIN_CLASS_FOUND,
            MAIN_CLASS_NOT_FOUND,
            MULTIPLE_MAIN_CLASSES;

        }
    }
}

