/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.async.AsyncStep;
import com.google.cloud.tools.jib.builder.TimerEventDispatcher;
import com.google.cloud.tools.jib.cache.Cache;
import com.google.cloud.tools.jib.cache.CacheCorruptedException;
import com.google.cloud.tools.jib.cache.CachedLayer;
import com.google.cloud.tools.jib.configuration.BuildConfiguration;
import com.google.cloud.tools.jib.http.Authorization;
import com.google.cloud.tools.jib.image.DescriptorDigest;
import com.google.cloud.tools.jib.registry.RegistryClient;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;

class PullAndCacheBaseImageLayerStep
implements AsyncStep<CachedLayer>,
Callable<CachedLayer> {
    private static final String DESCRIPTION = "Pulling base image layer %s";
    private final BuildConfiguration buildConfiguration;
    private final DescriptorDigest layerDigest;
    @Nullable
    private final Authorization pullAuthorization;
    private final ListenableFuture<CachedLayer> listenableFuture;

    PullAndCacheBaseImageLayerStep(ListeningExecutorService listeningExecutorService, BuildConfiguration buildConfiguration, DescriptorDigest layerDigest, @Nullable Authorization pullAuthorization) {
        this.buildConfiguration = buildConfiguration;
        this.layerDigest = layerDigest;
        this.pullAuthorization = pullAuthorization;
        this.listenableFuture = listeningExecutorService.submit((Callable)this);
    }

    @Override
    public ListenableFuture<CachedLayer> getFuture() {
        return this.listenableFuture;
    }

    @Override
    public CachedLayer call() throws IOException, CacheCorruptedException {
        try (TimerEventDispatcher ignored = new TimerEventDispatcher(this.buildConfiguration.getEventDispatcher(), String.format(DESCRIPTION, this.layerDigest));){
            Cache cache = this.buildConfiguration.getBaseImageLayersCache();
            Optional<CachedLayer> optionalCachedLayer = cache.retrieve(this.layerDigest);
            if (optionalCachedLayer.isPresent()) {
                CachedLayer cachedLayer = optionalCachedLayer.get();
                return cachedLayer;
            }
            RegistryClient registryClient = this.buildConfiguration.newBaseImageRegistryClientFactory().setAuthorization(this.pullAuthorization).newRegistryClient();
            CachedLayer cachedLayer = cache.writeCompressedLayer(registryClient.pullBlob(this.layerDigest));
            return cachedLayer;
        }
    }
}

