/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.async.AsyncStep;
import com.google.cloud.tools.jib.async.NonBlockingSteps;
import com.google.cloud.tools.jib.blob.BlobDescriptor;
import com.google.cloud.tools.jib.builder.steps.BuildAndCacheApplicationLayerStep;
import com.google.cloud.tools.jib.builder.steps.BuildImageStep;
import com.google.cloud.tools.jib.builder.steps.BuildResult;
import com.google.cloud.tools.jib.builder.steps.PullAndCacheBaseImageLayerStep;
import com.google.cloud.tools.jib.builder.steps.PullAndCacheBaseImageLayersStep;
import com.google.cloud.tools.jib.configuration.BuildConfiguration;
import com.google.cloud.tools.jib.docker.DockerClient;
import com.google.cloud.tools.jib.docker.ImageToTarballTranslator;
import com.google.cloud.tools.jib.event.events.LogEvent;
import com.google.cloud.tools.jib.image.DescriptorDigest;
import com.google.cloud.tools.jib.image.Image;
import com.google.cloud.tools.jib.image.ImageReference;
import com.google.cloud.tools.jib.image.Layer;
import com.google.cloud.tools.jib.image.json.BuildableManifestTemplate;
import com.google.cloud.tools.jib.image.json.ImageToJsonTranslator;
import com.google.cloud.tools.jib.json.JsonTemplateMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteStreams;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;

class LoadDockerStep
implements AsyncStep<BuildResult>,
Callable<BuildResult> {
    private final DockerClient dockerClient;
    private final BuildConfiguration buildConfiguration;
    private final PullAndCacheBaseImageLayersStep pullAndCacheBaseImageLayersStep;
    private final ImmutableList<BuildAndCacheApplicationLayerStep> buildAndCacheApplicationLayerSteps;
    private final BuildImageStep buildImageStep;
    private final ListeningExecutorService listeningExecutorService;
    private final ListenableFuture<BuildResult> listenableFuture;

    LoadDockerStep(ListeningExecutorService listeningExecutorService, DockerClient dockerClient, BuildConfiguration buildConfiguration, PullAndCacheBaseImageLayersStep pullAndCacheBaseImageLayersStep, ImmutableList<BuildAndCacheApplicationLayerStep> buildAndCacheApplicationLayerSteps, BuildImageStep buildImageStep) {
        this.listeningExecutorService = listeningExecutorService;
        this.dockerClient = dockerClient;
        this.buildConfiguration = buildConfiguration;
        this.pullAndCacheBaseImageLayersStep = pullAndCacheBaseImageLayersStep;
        this.buildAndCacheApplicationLayerSteps = buildAndCacheApplicationLayerSteps;
        this.buildImageStep = buildImageStep;
        this.listenableFuture = Futures.whenAllSucceed((ListenableFuture[])new ListenableFuture[]{pullAndCacheBaseImageLayersStep.getFuture(), buildImageStep.getFuture()}).call((Callable)this, (Executor)listeningExecutorService);
    }

    @Override
    public ListenableFuture<BuildResult> getFuture() {
        return this.listenableFuture;
    }

    @Override
    public BuildResult call() throws ExecutionException, InterruptedException {
        ImmutableList.Builder dependenciesBuilder = ImmutableList.builder();
        for (PullAndCacheBaseImageLayerStep pullAndCacheBaseImageLayerStep : NonBlockingSteps.get(this.pullAndCacheBaseImageLayersStep)) {
            dependenciesBuilder.add(pullAndCacheBaseImageLayerStep.getFuture());
        }
        for (BuildAndCacheApplicationLayerStep buildAndCacheApplicationLayerStep : this.buildAndCacheApplicationLayerSteps) {
            dependenciesBuilder.add(buildAndCacheApplicationLayerStep.getFuture());
        }
        dependenciesBuilder.add(NonBlockingSteps.get(this.buildImageStep).getFuture());
        return (BuildResult)Futures.whenAllSucceed((Iterable)dependenciesBuilder.build()).call(this::afterPushBaseImageLayerFuturesFuture, (Executor)this.listeningExecutorService).get();
    }

    private BuildResult afterPushBaseImageLayerFuturesFuture() throws ExecutionException, InterruptedException, IOException {
        Image<Layer> image = NonBlockingSteps.get(NonBlockingSteps.get(this.buildImageStep));
        ImageReference targetImageReference = this.buildConfiguration.getTargetImageConfiguration().getImage();
        this.buildConfiguration.getEventDispatcher().dispatch(LogEvent.lifecycle("Loading to Docker daemon..."));
        this.dockerClient.load(new ImageToTarballTranslator(image).toTarballBlob(targetImageReference));
        for (String tag : this.buildConfiguration.getAllTargetImageTags()) {
            if (tag.equals(targetImageReference.getTag())) continue;
            this.dockerClient.tag(targetImageReference, targetImageReference.withTag(tag));
        }
        ImageToJsonTranslator imageToJsonTranslator = new ImageToJsonTranslator(image);
        BlobDescriptor containerConfigurationBlobDescriptor = imageToJsonTranslator.getContainerConfigurationBlob().writeTo(ByteStreams.nullOutputStream());
        BuildableManifestTemplate manifestTemplate = imageToJsonTranslator.getManifestTemplate(this.buildConfiguration.getTargetFormat(), containerConfigurationBlobDescriptor);
        DescriptorDigest imageDigest = JsonTemplateMapper.toBlob(manifestTemplate).writeTo(ByteStreams.nullOutputStream()).getDigest();
        DescriptorDigest imageId = containerConfigurationBlobDescriptor.getDigest();
        return new BuildResult(imageDigest, imageId);
    }
}

