/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.async.AsyncStep;
import com.google.cloud.tools.jib.async.NonBlockingSteps;
import com.google.cloud.tools.jib.configuration.BuildConfiguration;
import com.google.cloud.tools.jib.event.events.LogEvent;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;

class FinalizingStep
implements AsyncStep<Void>,
Callable<Void> {
    private final BuildConfiguration buildConfiguration;
    private final List<AsyncStep<? extends ImmutableList<? extends AsyncStep<?>>>> futureDependencyLists;
    private final ListeningExecutorService listeningExecutorService;
    private final ListenableFuture<Void> listenableFuture;

    FinalizingStep(ListeningExecutorService listeningExecutorService, BuildConfiguration buildConfiguration, List<AsyncStep<? extends ImmutableList<? extends AsyncStep<?>>>> wrappedDependencyLists, List<? extends AsyncStep<?>> dependencyList) {
        this.listeningExecutorService = listeningExecutorService;
        this.buildConfiguration = buildConfiguration;
        this.futureDependencyLists = wrappedDependencyLists;
        ArrayList<Object> dependenciesFutures = new ArrayList<Object>(wrappedDependencyLists.size() + dependencyList.size());
        for (AsyncStep<ImmutableList<AsyncStep<?>>> asyncStep : wrappedDependencyLists) {
            dependenciesFutures.add(asyncStep.getFuture());
        }
        for (AsyncStep<Object> asyncStep : dependencyList) {
            dependenciesFutures.add(asyncStep.getFuture());
        }
        this.listenableFuture = Futures.whenAllSucceed(dependenciesFutures).call((Callable)this, (Executor)listeningExecutorService);
    }

    @Override
    public ListenableFuture<Void> getFuture() {
        return this.listenableFuture;
    }

    @Override
    public Void call() throws ExecutionException {
        ArrayList unwrappedDependencies = new ArrayList();
        for (AsyncStep<? extends ImmutableList<? extends AsyncStep<?>>> asyncStep : this.futureDependencyLists) {
            for (AsyncStep unwrappedDependency : NonBlockingSteps.get(asyncStep)) {
                unwrappedDependencies.add(unwrappedDependency.getFuture());
            }
        }
        Futures.whenAllSucceed(unwrappedDependencies).call(() -> {
            this.buildConfiguration.getEventDispatcher().dispatch(LogEvent.lifecycle("Finalizing..."));
            return null;
        }, (Executor)this.listeningExecutorService);
        return null;
    }
}

