/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.api;

import com.google.cloud.tools.jib.api.TargetImage;
import com.google.cloud.tools.jib.builder.BuildSteps;
import com.google.cloud.tools.jib.configuration.BuildConfiguration;
import com.google.cloud.tools.jib.configuration.ImageConfiguration;
import com.google.cloud.tools.jib.image.ImageReference;
import com.google.cloud.tools.jib.image.InvalidImageReferenceException;
import java.nio.file.Path;

public class TarImage
implements TargetImage {
    private final ImageReference imageReference;
    private final Path outputFile;

    public static Builder named(ImageReference imageReference) {
        return new Builder(imageReference);
    }

    public static Builder named(String imageReference) throws InvalidImageReferenceException {
        return TarImage.named(ImageReference.parse(imageReference));
    }

    private TarImage(ImageReference imageReference, Path outputFile) {
        this.imageReference = imageReference;
        this.outputFile = outputFile;
    }

    @Override
    public ImageConfiguration toImageConfiguration() {
        return ImageConfiguration.builder(this.imageReference).build();
    }

    @Override
    public BuildSteps toBuildSteps(BuildConfiguration buildConfiguration) {
        return BuildSteps.forBuildToTar(this.outputFile, buildConfiguration);
    }

    Path getOutputFile() {
        return this.outputFile;
    }

    public static class Builder {
        private final ImageReference imageReference;

        private Builder(ImageReference imageReference) {
            this.imageReference = imageReference;
        }

        public TarImage saveTo(Path outputFile) {
            return new TarImage(this.imageReference, outputFile);
        }
    }
}

