package com.github.zhurlik.task

import com.github.zhurlik.extension.JBossModule
import groovy.util.logging.Slf4j
import groovy.util.slurpersupport.GPathResult
import org.gradle.api.DefaultTask
import org.gradle.api.tasks.TaskAction

import static java.io.File.separator

/**
 * A task to check if a xml descriptor is valid.
 *
 * @author zhurlik@gmail.com
 */
@Slf4j
class CheckModulesTask extends DefaultTask {
    static final String NAME = 'checkModules'

    @TaskAction
    def checkModules() {
        log.info('>> Validation process for JBoss Modules')

        // generated by makeModules task
        project.jbossrepos.each {
            new File([project.buildDir.path, 'install', it.name, 'modules'].join(separator)).eachDirRecurse() {
                it.eachFileMatch(~/module.xml/) { file ->
                    GPathResult m = new XmlSlurper().parse(file)
                    //availableModules.put(m.@name, file)
                }
            }
        }

        project.modules.each() { JBossModule m ->
            boolean valid = m.isValid()

            log.debug(">> Module: ${m.moduleName}")
            log.debug("\tDescriptor:\"${m.moduleName}\", valid=$valid")

            if (valid) {
                GPathResult desc = new XmlSlurper().parseText(m.moduleDescriptor)
                desc.dependencies.module.each {
//                    if (!availableModules.containsKey(it.@name)) {
//                        println '\tWARNING: Dependency:' + it.@name + ' is missing'
//                    }
                }
            }
        }
    }
}
