/*
 * Decompiled with CFR 0.152.
 */
package com.github.spotbugs.snom.internal;

import com.github.spotbugs.snom.SpotBugsTask;
import com.github.spotbugs.snom.internal.SpotBugsRunner;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.process.ExecOperations;
import org.gradle.process.JavaExecSpec;
import org.gradle.process.internal.ExecException;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SpotBugsRunnerForHybrid
extends SpotBugsRunner {
    private final WorkerExecutor workerExecutor;

    public SpotBugsRunnerForHybrid(@NonNull WorkerExecutor workerExecutor) {
        this.workerExecutor = Objects.requireNonNull(workerExecutor);
    }

    @Override
    public void run(@NotNull SpotBugsTask task) {
        this.workerExecutor.noIsolation().submit(SpotBugsExecutor.class, this.configureWorkerSpec(task));
    }

    private Action<SpotBugsWorkParameters> configureWorkerSpec(SpotBugsTask task) {
        return params -> {
            ArrayList<String> args = new ArrayList<String>();
            args.add("-exitcode");
            args.addAll(this.buildArguments(task));
            params.getClasspath().setFrom((Iterable)task.getSpotbugsClasspath());
            params.getJvmArgs().set(this.buildJvmArguments(task));
            params.getArgs().set(args);
            String maxHeapSize = (String)task.getMaxHeapSize().getOrNull();
            if (maxHeapSize != null) {
                params.getMaxHeapSize().set((Object)maxHeapSize);
            }
            params.getIgnoreFailures().set((Object)task.getIgnoreFailures());
            params.getShowStackTraces().set((Object)task.getShowStackTraces());
            params.getReportsDir().set((Provider)task.getReportsDir());
        };
    }

    public static abstract class SpotBugsExecutor
    implements WorkAction<SpotBugsWorkParameters> {
        private final Logger log = LoggerFactory.getLogger(this.getClass());
        private final ExecOperations execOperations;

        @Inject
        public SpotBugsExecutor(ExecOperations execOperations) {
            this.execOperations = Objects.requireNonNull(execOperations);
        }

        public void execute() {
            SpotBugsWorkParameters params = (SpotBugsWorkParameters)this.getParameters();
            try {
                this.execOperations.javaexec(this.configureJavaExec(params)).rethrowFailure().assertNormalExitValue();
            }
            catch (ExecException e) {
                if (((Boolean)params.getIgnoreFailures().getOrElse((Object)Boolean.FALSE)).booleanValue()) {
                    this.log.warn("SpotBugs reported failures", (Throwable)((Boolean)params.getShowStackTraces().getOrElse((Object)Boolean.FALSE) != false ? e : null));
                }
                String errorMessage = "Verification failed: SpotBugs execution thrown exception.";
                List reportPaths = params.getReportsDir().getAsFileTree().getFiles().stream().map(File::toPath).map(Path::toUri).map(URI::toString).collect(Collectors.toList());
                if (!reportPaths.isEmpty()) {
                    errorMessage = errorMessage + "See the report at: " + String.join((CharSequence)",", reportPaths);
                }
                throw new GradleException(errorMessage, (Throwable)e);
            }
        }

        private Action<? super JavaExecSpec> configureJavaExec(SpotBugsWorkParameters params) {
            return spec -> {
                spec.setJvmArgs((List)params.getJvmArgs().get());
                spec.classpath(new Object[]{params.getClasspath()});
                spec.setArgs((List)params.getArgs().get());
                spec.setMain("edu.umd.cs.findbugs.FindBugs2");
                String maxHeapSize = (String)params.getMaxHeapSize().getOrNull();
                if (maxHeapSize != null) {
                    spec.setMaxHeapSize(maxHeapSize);
                }
            };
        }
    }

    public static interface SpotBugsWorkParameters
    extends WorkParameters {
        public ConfigurableFileCollection getClasspath();

        public Property<String> getMaxHeapSize();

        public ListProperty<String> getArgs();

        public ListProperty<String> getJvmArgs();

        public Property<Boolean> getIgnoreFailures();

        public Property<Boolean> getShowStackTraces();

        public DirectoryProperty getReportsDir();
    }
}

