/*
 * Decompiled with CFR 0.152.
 */
package com.github.spotbugs.snom;

import com.github.spotbugs.snom.SpotBugsExtension;
import com.github.spotbugs.snom.SpotBugsPlugin;
import com.github.spotbugs.snom.SpotBugsTask;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.Properties;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.plugins.ReportingBasePlugin;
import org.gradle.util.GradleVersion;

public class SpotBugsBasePlugin
implements Plugin<Project> {
    private static final GradleVersion SUPPORTED_VERSION = GradleVersion.version((String)"5.6");

    public void apply(Project project) {
        this.verifyGradleVersion(GradleVersion.current());
        project.getPluginManager().apply(ReportingBasePlugin.class);
        SpotBugsExtension extension = this.createExtension(project);
        this.createConfiguration(project, extension);
        this.createPluginConfiguration(project);
        project.getTasks().withType(SpotBugsTask.class).configureEach(task -> task.init(extension));
    }

    private SpotBugsExtension createExtension(Project project) {
        return (SpotBugsExtension)project.getExtensions().create("spotbugs", SpotBugsExtension.class, new Object[]{project, project.getObjects()});
    }

    private void createConfiguration(Project project, SpotBugsExtension extension) {
        Properties props = this.loadProperties();
        extension.getToolVersion().convention((Object)props.getProperty("spotbugs-version"));
        Configuration configuration = ((Configuration)project.getConfigurations().create("spotbugs")).setDescription("configuration for the SpotBugs engine").setVisible(false).setTransitive(true);
        configuration.defaultDependencies(dependencies -> dependencies.add((Object)project.getDependencies().create((Object)("com.github.spotbugs:spotbugs:" + (String)extension.getToolVersion().get()))));
        Configuration spotbugsSlf4j = ((Configuration)project.getConfigurations().create("spotbugsSlf4j")).setDescription("configuration for the SLF4J provider to run SpotBugs").setVisible(false).setTransitive(true);
        spotbugsSlf4j.defaultDependencies(dependencies -> dependencies.add((Object)project.getDependencies().create((Object)("org.slf4j:slf4j-simple:" + props.getProperty("slf4j-version")))));
    }

    Properties loadProperties() {
        Properties properties;
        block8: {
            URL url = SpotBugsPlugin.class.getClassLoader().getResource("spotbugs-gradle-plugin.properties");
            InputStream input = url.openStream();
            try {
                Properties prop = new Properties();
                prop.load(input);
                properties = prop;
                if (input == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            input.close();
        }
        return properties;
    }

    private Configuration createPluginConfiguration(Project project) {
        return ((Configuration)project.getConfigurations().create("spotbugsPlugins")).setDescription("configuration for the external SpotBugs plugins").setVisible(false).setTransitive(true);
    }

    void verifyGradleVersion(GradleVersion version) {
        if (version.compareTo(SUPPORTED_VERSION) < 0) {
            String message = String.format("Gradle version %s is unsupported. Please use %s or later.", version, SUPPORTED_VERSION);
            throw new IllegalArgumentException(message);
        }
    }
}

