/*
 * Decompiled with CFR 0.152.
 */
package com.github.nicholashauschild.depinfo;

import com.github.nicholashauschild.depinfo.Artifact;
import com.github.nicholashauschild.depinfo.DepInfoExtension;
import com.github.nicholashauschild.depinfo.DepInfoPluginKt;
import com.github.nicholashauschild.depinfo.DepInfoTask;
import java.io.File;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.language.jvm.tasks.ProcessResources;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u0013J\b\u0010\u0014\u001a\u00020\u0011H\u0007J\u001b\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b\u0018J\u0015\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b\u001aJ\u0015\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b\u001cJ\u000f\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0000\u00a2\u0006\u0002\b\u001fJ\u001b\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b\"J\r\u0010#\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b$R \u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR$\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006%"}, d2={"Lcom/github/nicholashauschild/depinfo/DepInfoTask;", "Lorg/gradle/api/DefaultTask;", "()V", "dependencyInfoFile", "Ljava/io/File;", "getDependencyInfoFile", "()Ljava/io/File;", "setDependencyInfoFile", "(Ljava/io/File;)V", "dependentArtifacts", "", "Lcom/github/nicholashauschild/depinfo/Artifact;", "getDependentArtifacts", "()Ljava/util/Set;", "setDependentArtifacts", "(Ljava/util/Set;)V", "checkFile", "", "file", "checkFile$gradle_dependency_info_plugin_main", "exec", "getArtifacts", "extension", "Lcom/github/nicholashauschild/depinfo/DepInfoExtension;", "getArtifacts$gradle_dependency_info_plugin_main", "getDestinitionDir", "getDestinitionDir$gradle_dependency_info_plugin_main", "getOutputFile", "getOutputFile$gradle_dependency_info_plugin_main", "getProcessResourcesTask", "Lorg/gradle/language/jvm/tasks/ProcessResources;", "getProcessResourcesTask$gradle_dependency_info_plugin_main", "getResolvedArtifacts", "Lorg/gradle/api/artifacts/ResolvedArtifact;", "getResolvedArtifacts$gradle_dependency_info_plugin_main", "populateFile", "populateFile$gradle_dependency_info_plugin_main", "gradle-dependency-info-plugin_main"})
public class DepInfoTask
extends DefaultTask {
    @Input
    @NotNull
    private Set<Artifact> dependentArtifacts;
    @OutputFile
    @Nullable
    private File dependencyInfoFile;

    @NotNull
    public final Set<Artifact> getDependentArtifacts() {
        return this.dependentArtifacts;
    }

    public final void setDependentArtifacts(@NotNull Set<Artifact> set) {
        Intrinsics.checkParameterIsNotNull(set, (String)"<set-?>");
        this.dependentArtifacts = set;
    }

    @Nullable
    public final File getDependencyInfoFile() {
        return this.dependencyInfoFile;
    }

    public final void setDependencyInfoFile(@Nullable File file) {
        this.dependencyInfoFile = file;
    }

    @TaskAction
    public final void exec() {
        this.populateFile$gradle_dependency_info_plugin_main();
    }

    public final void populateFile$gradle_dependency_info_plugin_main() {
        File file = this.dependencyInfoFile;
        if (file != null) {
            File file2;
            File file3 = file2 = file;
            this.checkFile$gradle_dependency_info_plugin_main(file3);
            Iterable $receiver$iv = this.dependentArtifacts;
            for (Object element$iv : $receiver$iv) {
                Artifact it = (Artifact)element$iv;
                FilesKt.appendText$default((File)file3, (String)("dependency." + it.getName() + '=' + it.getArtifactGroup() + '/' + it.getArtifactName() + '/' + it.getArtifactVersion() + '\n'), null, (int)2, null);
            }
        }
    }

    public final void checkFile$gradle_dependency_info_plugin_main(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        if (file.exists()) {
            file.delete();
        }
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        file.createNewFile();
    }

    @NotNull
    public final Set<Artifact> getArtifacts$gradle_dependency_info_plugin_main(@NotNull DepInfoExtension extension) {
        Intrinsics.checkParameterIsNotNull((Object)extension, (String)"extension");
        return SequencesKt.toHashSet((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)this.getResolvedArtifacts$gradle_dependency_info_plugin_main(extension)), (Function1)getArtifacts.1.INSTANCE));
    }

    @NotNull
    public final Set<ResolvedArtifact> getResolvedArtifacts$gradle_dependency_info_plugin_main(@NotNull DepInfoExtension extension) {
        Intrinsics.checkParameterIsNotNull((Object)extension, (String)"extension");
        Object object = (Configuration)this.getProject().getConfigurations().findByName(extension.getConfiguration());
        if (object == null || (object = object.getResolvedConfiguration()) == null || (object = object.getResolvedArtifacts()) == null) {
            object = SetsKt.emptySet();
        }
        return object;
    }

    @NotNull
    public final File getOutputFile$gradle_dependency_info_plugin_main(@NotNull DepInfoExtension extension) {
        Intrinsics.checkParameterIsNotNull((Object)extension, (String)"extension");
        return new File(this.getDestinitionDir$gradle_dependency_info_plugin_main(extension), "dependency-info.properties");
    }

    @NotNull
    public final File getDestinitionDir$gradle_dependency_info_plugin_main(@NotNull DepInfoExtension extension) {
        File file;
        Intrinsics.checkParameterIsNotNull((Object)extension, (String)"extension");
        ProcessResources prTask = this.getProcessResourcesTask$gradle_dependency_info_plugin_main();
        File extDir = extension.getDestinationDir();
        if (extDir != null) {
            file = extDir;
        } else if (prTask != null) {
            File file2 = prTask.getDestinationDir();
            file = file2;
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"prTask.destinationDir");
        } else {
            throw (Throwable)new GradleException("No destinationDir determined!  You must apply the Java Plugin, or specify the property 'dependencyInfo.destinationDir'");
        }
        return file;
    }

    @Nullable
    public final ProcessResources getProcessResourcesTask$gradle_dependency_info_plugin_main() {
        Object object = this.getProject().getTasks().findByName("processResources");
        if (!(object instanceof ProcessResources)) {
            object = null;
        }
        return (ProcessResources)object;
    }

    public DepInfoTask() {
        Set set;
        DepInfoTask depInfoTask = this;
        depInfoTask.dependentArtifacts = set = SetsKt.emptySet();
        this.getProject().afterEvaluate((Action)new Action<Project>(){

            public final void execute(Project it) {
                DepInfoExtension extension = (DepInfoExtension)this.getProject().getExtensions().getByType(DepInfoPluginKt.getEXTENSION_CLASS());
                if (this.getProject().getPlugins().hasPlugin(JavaPlugin.class)) {
                    this.dependsOn(new Object[]{"compileJava"});
                    ProcessResources processResources = this.getProcessResourcesTask$gradle_dependency_info_plugin_main();
                    if (processResources == null) {
                        Intrinsics.throwNpe();
                    }
                    processResources.dependsOn(new Object[]{DepInfoPluginKt.getDEP_INFO_TASK_NAME()});
                }
                DepInfoExtension depInfoExtension = extension;
                Intrinsics.checkExpressionValueIsNotNull((Object)depInfoExtension, (String)"extension");
                this.setDependentArtifacts(this.getArtifacts$gradle_dependency_info_plugin_main(depInfoExtension));
                this.setDependencyInfoFile(this.getOutputFile$gradle_dependency_info_plugin_main(extension));
            }
        });
    }
}

