/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.vcs;

import com.github.blindpirate.gogradle.GogradleGlobal;
import com.github.blindpirate.gogradle.core.dependency.parse.NotationConverter;
import com.github.blindpirate.gogradle.vcs.Bazaar;
import com.github.blindpirate.gogradle.vcs.Git;
import com.github.blindpirate.gogradle.vcs.Mercurial;
import com.github.blindpirate.gogradle.vcs.Svn;
import com.github.blindpirate.gogradle.vcs.VcsAccessor;
import com.github.blindpirate.gogradle.vcs.VcsScheme;
import com.google.inject.Key;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public enum VcsType {
    GIT("git", Git.class, Arrays.asList(VcsScheme.GIT, VcsScheme.HTTPS, VcsScheme.HTTP, VcsScheme.GIT_SSH, VcsScheme.SSH)),
    MERCURIAL("hg", Mercurial.class, Arrays.asList(VcsScheme.HTTPS, VcsScheme.HTTP, VcsScheme.SSH)),
    SVN("svn", Svn.class, Arrays.asList(VcsScheme.HTTPS, VcsScheme.HTTP, VcsScheme.SVN, VcsScheme.SVN_SSH)),
    BAZAAR("bzr", Bazaar.class, Arrays.asList(VcsScheme.HTTPS, VcsScheme.HTTP, VcsScheme.BZR, VcsScheme.BZR_SSH));

    private String name;
    private String suffix;
    private Class<? extends Annotation> annoClass;
    private List<VcsScheme> schemes;

    private VcsType(String name, Class<? extends Annotation> annoClass, List<VcsScheme> schemes) {
        this.name = name;
        this.suffix = "." + name;
        this.annoClass = annoClass;
        this.schemes = schemes;
    }

    public String getName() {
        return this.name;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public List<VcsScheme> getSchemes() {
        return this.schemes;
    }

    public static Optional<VcsType> of(String name) {
        return Arrays.stream(VcsType.values()).filter(type -> type.toString().equalsIgnoreCase(name) || type.getName().equalsIgnoreCase(name)).findFirst();
    }

    public <T> T getService(Class<T> serviceClass) {
        return GogradleGlobal.getInstance(Key.get(serviceClass, this.annoClass));
    }

    public VcsAccessor getAccessor() {
        return this.getService(VcsAccessor.class);
    }

    public NotationConverter getNotationConverter() {
        return this.getService(NotationConverter.class);
    }
}

