/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.vcs;

import com.github.blindpirate.gogradle.core.cache.GlobalCacheManager;
import com.github.blindpirate.gogradle.core.cache.ProjectCacheManager;
import com.github.blindpirate.gogradle.core.dependency.GolangDependency;
import com.github.blindpirate.gogradle.core.dependency.GolangDependencySet;
import com.github.blindpirate.gogradle.core.dependency.NotationDependency;
import com.github.blindpirate.gogradle.core.dependency.ResolveContext;
import com.github.blindpirate.gogradle.core.dependency.ResolvedDependency;
import com.github.blindpirate.gogradle.core.dependency.resolve.AbstractVcsDependencyManager;
import com.github.blindpirate.gogradle.core.exceptions.DependencyResolutionException;
import com.github.blindpirate.gogradle.util.Assert;
import com.github.blindpirate.gogradle.util.IOUtils;
import com.github.blindpirate.gogradle.util.StringUtils;
import com.github.blindpirate.gogradle.vcs.GitMercurialAccessor;
import com.github.blindpirate.gogradle.vcs.GitMercurialCommit;
import com.github.blindpirate.gogradle.vcs.VcsNotationDependency;
import com.github.blindpirate.gogradle.vcs.VcsResolvedDependency;
import com.github.blindpirate.gogradle.vcs.VcsType;
import java.io.File;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

public abstract class GitMercurialDependencyManager
extends AbstractVcsDependencyManager<GitMercurialCommit> {
    protected static final Logger LOGGER = Logging.getLogger(GitMercurialDependencyManager.class);

    public GitMercurialDependencyManager(GlobalCacheManager globalCacheManager, ProjectCacheManager projectCacheManager) {
        super(globalCacheManager, projectCacheManager);
    }

    protected abstract GitMercurialAccessor getAccessor();

    @Override
    protected void doReset(ResolvedDependency dependency, File repoRoot) {
        VcsResolvedDependency vcsResolvedDependency = (VcsResolvedDependency)dependency;
        this.getAccessor().checkout(repoRoot, vcsResolvedDependency.getVersion());
    }

    @Override
    protected ResolvedDependency createResolvedDependency(NotationDependency dependency, File repoRoot, GitMercurialCommit commit, ResolveContext context) {
        VcsResolvedDependency ret = VcsResolvedDependency.builder().withNotationDependency(dependency).withCommitId(commit.getId()).withCommitTime(commit.getCommitTime()).build();
        GolangDependencySet dependencies = context.produceTransitiveDependencies(ret, repoRoot);
        ret.setDependencies(dependencies);
        return ret;
    }

    protected abstract VcsType getVcsType();

    @Override
    protected boolean versionExistsInRepo(File repoRoot, GolangDependency dependency) {
        if (dependency instanceof VcsNotationDependency) {
            VcsNotationDependency d = (VcsNotationDependency)dependency;
            if (d.isLatest()) {
                return false;
            }
            if (d.getCommit() != null) {
                return this.getAccessor().findCommit(repoRoot, d.getCommit()).isPresent();
            }
            if (d.getTag() != null) {
                return this.findMatchingTag(repoRoot, d.getTag()).isPresent();
            }
            if (d.getBranch() != null) {
                return false;
            }
            throw new IllegalStateException("Shouldn't be here: " + dependency);
        }
        VcsResolvedDependency d = (VcsResolvedDependency)dependency;
        return this.getAccessor().findCommit(repoRoot, d.getVersion()).isPresent();
    }

    @Override
    protected void resetToSpecificVersion(File repository, GitMercurialCommit commit) {
        this.getAccessor().checkout(repository, commit.getId());
    }

    private Optional<GitMercurialCommit> findMatchingTag(File repository, String tag) {
        Optional<GitMercurialCommit> commit = this.getAccessor().findCommitByTagOrBranch(repository, tag);
        if (commit.isPresent()) {
            return commit;
        }
        return this.findCommitBySemVersion(repository, tag);
    }

    @Override
    protected GitMercurialCommit determineVersion(File repoDir, NotationDependency dependency) {
        VcsNotationDependency notationDep = (VcsNotationDependency)dependency;
        if (notationDep.isLatest()) {
            return this.getAccessor().headCommitOfBranch(repoDir, this.getAccessor().getDefaultBranch(repoDir));
        }
        if (StringUtils.isNotBlank(notationDep.getCommit())) {
            Optional<GitMercurialCommit> commit = this.getAccessor().findCommit(repoDir, notationDep.getCommit());
            if (commit.isPresent()) {
                return commit.get();
            }
            throw DependencyResolutionException.cannotFindGitCommit(notationDep);
        }
        if (StringUtils.isNotBlank(notationDep.getTag())) {
            Optional<GitMercurialCommit> commit = this.findMatchingTag(repoDir, notationDep.getTag());
            if (commit.isPresent()) {
                return commit.get();
            }
            throw DependencyResolutionException.cannotFindGitTag(dependency, notationDep.getTag(), repoDir);
        }
        return this.getAccessor().headCommitOfBranch(repoDir, notationDep.getBranch());
    }

    private Optional<GitMercurialCommit> findCommitBySemVersion(File repository, String semVersionExpression) {
        List<GitMercurialCommit> tags = this.getAccessor().getAllTags(repository);
        List satisfiedTags = tags.stream().filter(tag -> tag.satisfies(semVersionExpression)).collect(Collectors.toList());
        if (satisfiedTags.isEmpty()) {
            return Optional.empty();
        }
        satisfiedTags.sort((tag1, tag2) -> tag2.getSemVersion().compareTo(tag1.getSemVersion()));
        return Optional.of(satisfiedTags.get(0));
    }

    @Override
    protected void updateRepository(GolangDependency dependency, File repoRoot) {
        String url = this.getAccessor().getRemoteUrl(repoRoot);
        if (dependency == null) {
            LOGGER.info("Fetching from {}", (Object)url);
        } else {
            LOGGER.info("Fetching {} from {}", (Object)dependency, (Object)url);
        }
        this.getAccessor().update(repoRoot);
    }

    @Override
    protected void initRepository(String dependencyName, List<String> urls, File repoRoot) {
        this.tryCloneWithUrls(dependencyName, urls, repoRoot);
        this.updateRepository(null, repoRoot);
    }

    private void tryCloneWithUrls(String name, List<String> urls, File directory) {
        Assert.isNotEmpty(urls, "Urls of " + name + " should not be empty!");
        for (int i = 0; i < urls.size(); ++i) {
            IOUtils.clearDirectory(directory);
            String url = urls.get(i);
            try {
                this.getAccessor().clone(url, directory);
                return;
            }
            catch (Throwable e) {
                LOGGER.debug("Cloning with url {} failed, the cause is {}", (Object)url, (Object)e.getMessage());
                if (i != urls.size() - 1) continue;
                throw DependencyResolutionException.cannotCloneRepository(name, e);
            }
        }
    }
}

