/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.vcs;

import com.github.zafarkhaja.semver.ParseException;
import com.github.zafarkhaja.semver.Version;
import java.util.regex.Pattern;

public class GitMercurialCommit {
    private static final Pattern PATTERN_STARTING_WITH_V = Pattern.compile("^[vV]\\d.*");
    private String id;
    private String tag;
    private long commitTime;
    private Version semVersion;

    public String getId() {
        return this.id;
    }

    public long getCommitTime() {
        return this.commitTime;
    }

    public String getTag() {
        return this.tag;
    }

    public Version getSemVersion() {
        return this.semVersion;
    }

    public boolean satisfies(String semVersionExpression) {
        boolean ret = this.satisfiesSafely(semVersionExpression);
        if (!ret && PATTERN_STARTING_WITH_V.matcher(semVersionExpression).matches()) {
            return this.satisfiesSafely(semVersionExpression.substring(1));
        }
        return ret;
    }

    private boolean satisfiesSafely(String semVersionExpression) {
        try {
            return this.semVersion.satisfies(semVersionExpression);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static GitMercurialCommit of(String id, long unixMs) {
        return GitMercurialCommit.of(id, null, unixMs);
    }

    public static GitMercurialCommit of(String id, String tag, long unixMs) {
        GitMercurialCommit ret = new GitMercurialCommit();
        ret.id = id;
        ret.tag = tag;
        ret.commitTime = unixMs;
        if (tag != null) {
            ret.semVersion = GitMercurialCommit.parseSemVersion(tag);
            if (ret.semVersion == null && PATTERN_STARTING_WITH_V.matcher(tag).matches()) {
                ret.semVersion = GitMercurialCommit.parseSemVersion(tag.substring(1));
            }
        }
        return ret;
    }

    private static Version parseSemVersion(String tag) {
        try {
            return Version.valueOf((String)tag);
        }
        catch (ParseException | IllegalArgumentException e) {
            return null;
        }
    }
}

