/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.util;

import com.github.blindpirate.gogradle.util.IOUtils;
import com.github.blindpirate.gogradle.util.logging.ProgressMonitorInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Map;

public class HttpUtils {
    public static final String GET_METHOD = "GET";
    public static final String POST_METHOD = "POST";
    public static final String USER_AGENT = "user-agent";
    private static final int TEN_SECONDS = 10000;
    private static final int FOUR_KB = 4096;
    private static final int HTTP_INTERNAL_REDIRECTION = 307;

    public String get(String url) throws IOException {
        return this.get(url, null);
    }

    public String get(String url, Map<String, String> headers) throws IOException {
        return this.fetch(GET_METHOD, url, null, headers);
    }

    public String appendQueryParams(String url, Map<String, String> params) {
        StringBuilder fullUrl = new StringBuilder(url);
        if (params != null) {
            boolean first = url.indexOf(63) == -1;
            for (Map.Entry<String, String> param : params.entrySet()) {
                if (first) {
                    fullUrl.append('?');
                    first = false;
                } else {
                    fullUrl.append('&');
                }
                try {
                    fullUrl.append(URLEncoder.encode(param.getKey(), "UTF-8")).append('=');
                    fullUrl.append(URLEncoder.encode(param.getValue(), "UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            }
        }
        return fullUrl.toString();
    }

    private String fetch(String method, String url, String body, Map<String, String> headers) throws IOException {
        try (InputStream is = this.fetchAsInputStream(method, url, body, headers);){
            String string = IOUtils.toString(is);
            return string;
        }
    }

    private InputStream fetchAsInputStream(String method, String url, String body, Map<String, String> headers) throws IOException {
        if (headers != null && headers.containsKey(USER_AGENT)) {
            System.setProperty("http.agent", headers.get(USER_AGENT));
        }
        URL u = new URL(url);
        HttpURLConnection conn = (HttpURLConnection)u.openConnection();
        conn.setConnectTimeout(10000);
        conn.setReadTimeout(10000);
        if (method != null) {
            conn.setRequestMethod(method);
        }
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                conn.addRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        if (body != null) {
            conn.setDoOutput(true);
            OutputStream os = conn.getOutputStream();
            os.write(body.getBytes("UTF-8"));
            os.flush();
            os.close();
        }
        if (conn.getResponseCode() == 301 || conn.getResponseCode() == 302 || conn.getResponseCode() == 307) {
            String location = conn.getHeaderField("Location");
            return this.fetchAsInputStream(method, location, body, headers);
        }
        if (conn.getResponseCode() != 200) {
            throw new IOException("Error in accessing " + url + ", http response code: " + conn.getResponseCode());
        }
        return conn.getInputStream();
    }

    public void download(String url, Path filePath) throws IOException {
        InputStream is = this.fetchAsInputStream(GET_METHOD, url, null, null);
        Files.copy(new ProgressMonitorInputStream(url, is), filePath, StandardCopyOption.REPLACE_EXISTING);
    }
}

