/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.util;

import com.github.blindpirate.gogradle.util.StringUtils;
import java.util.Collection;

public class Assert {
    public static void isTrue(boolean value) {
        Assert.isTrue(value, "This value cannot be false!");
    }

    public static void isTrue(boolean value, String s) {
        if (!value) {
            throw new IllegalStateException(s);
        }
    }

    public static <T> T isNotNull(T obj, String s) {
        Assert.isTrue(obj != null, s);
        return obj;
    }

    public static <T> T isNotNull(T obj) {
        return Assert.isNotNull(obj, "This object cannot be null!");
    }

    public static String isNotBlank(String s) {
        Assert.isTrue(StringUtils.isNotBlank(s));
        return s;
    }

    public static String isNotBlank(String s, String message) {
        Assert.isTrue(StringUtils.isNotBlank(s), message);
        return s;
    }

    public static <T> void isNotEmpty(Collection<T> collection, String message) {
        Assert.isTrue(!collection.isEmpty(), message);
    }

    public static void isNull(Object obj) {
        Assert.isTrue(obj == null);
    }
}

