/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.task.go;

import com.github.blindpirate.gogradle.Go;
import com.github.blindpirate.gogradle.crossplatform.GoBinaryManager;
import com.github.blindpirate.gogradle.task.GolangTaskContainer;
import com.github.blindpirate.gogradle.util.CollectionUtils;
import com.github.blindpirate.gogradle.util.IOUtils;
import com.github.blindpirate.gogradle.util.StringUtils;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class Gofmt
extends Go {
    @Inject
    private GoBinaryManager goBinaryManager;

    public Gofmt() {
        this.setDescription("Run gofmt (https://golang.org/cmd/gofmt/).");
        this.dependsOn(new Object[]{GolangTaskContainer.PREPARE_TASK_NAME});
    }

    @Override
    public void afterEvaluate() {
        if (CollectionUtils.isEmpty(this.goActions)) {
            this.run(CollectionUtils.asStringList(this.getGofmtPath(), "-w", this.children()));
        }
    }

    private String getGofmtPath() {
        Path goBinPath = this.goBinaryManager.getBinaryPath();
        Path gofmtPath = goBinPath.resolve("../gofmt").normalize();
        return StringUtils.toUnixString(gofmtPath.toAbsolutePath());
    }

    public void gofmt(String arg) {
        this.run(this.getGofmtPath() + " " + arg);
    }

    protected List<String> children() {
        return IOUtils.safeListFiles(this.getProjectDir()).stream().filter(file -> !StringUtils.startsWithAny(file.getName(), "_", ".")).filter(file -> !"vendor".equals(file.getName())).filter(file -> file.isDirectory() || file.getName().endsWith(".go")).map(StringUtils::toUnixString).collect(Collectors.toList());
    }
}

