/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.task.go;

import com.github.blindpirate.gogradle.Go;
import com.github.blindpirate.gogradle.task.GolangTaskContainer;
import com.github.blindpirate.gogradle.util.CollectionUtils;
import com.github.blindpirate.gogradle.util.IOUtils;
import com.github.blindpirate.gogradle.util.StringUtils;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;

public class GoVet
extends Go {
    public GoVet() {
        this.setDescription("Run 'go vet' (https://golang.org/cmd/vet).");
        this.dependsOn(new Object[]{GolangTaskContainer.VENDOR_TASK_NAME});
    }

    @Override
    public void afterEvaluate() {
        if (CollectionUtils.isEmpty(this.goActions)) {
            this.vet(this.allSubGoFiles());
            this.vet(this.allSubDirectories());
        }
    }

    private void vet(List<String> fileNames) {
        if (!fileNames.isEmpty()) {
            this.go(CollectionUtils.asStringList("tool", "vet", fileNames));
        }
    }

    private List<String> allSubGoFiles() {
        return IOUtils.safeListFiles(this.getProjectDir()).stream().filter(File::isFile).filter(file -> !StringUtils.startsWithAny(file.getName(), "_", ".")).filter(file -> StringUtils.endsWithAny(file.getName(), ".go")).map(StringUtils::toUnixString).collect(Collectors.toList());
    }

    private List<String> allSubDirectories() {
        return IOUtils.safeListFiles(this.getProjectDir()).stream().filter(File::isDirectory).filter(file -> !StringUtils.startsWithAny(file.getName(), "_", ".")).filter(file -> !"vendor".equals(file.getName())).map(StringUtils::toUnixString).collect(Collectors.toList());
    }
}

