/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.task.go;

import com.github.blindpirate.gogradle.task.go.PackageTestResult;
import com.github.blindpirate.gogradle.util.DateUtils;
import com.github.blindpirate.gogradle.util.IOUtils;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Singleton;
import org.apache.commons.lang3.tuple.Pair;
import org.gradle.api.internal.tasks.testing.junit.result.TestClassResult;
import org.gradle.api.internal.tasks.testing.junit.result.TestMethodResult;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.testing.TestResult;

@Singleton
public class GoTestStdoutExtractor {
    private static final Logger LOGGER = Logging.getLogger(GoTestStdoutExtractor.class);
    private static final Map<String, TestResult.ResultType> RESULT_TYPE_MAP = ImmutableMap.of((Object)"PASS", (Object)TestResult.ResultType.SUCCESS, (Object)"FAIL", (Object)TestResult.ResultType.FAILURE);
    private static final Pattern TEST_START_LINE_PATTERN = Pattern.compile("=== RUN\\s+(\\w+)(/?)");
    private static final String TEST_START = "=== RUN";
    private static final String TEST_PASS = "--- PASS";
    private static final String TEST_FAIL = "--- FAIL";
    private static final String SETUP_FAILED_ERROR = "[setup failed]";
    private static final String BUILD_FAILED_ERROR = "[build failed]";
    private static final String CANNOT_LOAD_PACKAGE_ERROR = "can't load package";
    private static final String CANNOT_FIND_PACKAGE_ERROR = "cannot find package";
    private static final String RETURN_NON_ZERO = "go test return ";
    private static final AtomicLong GLOBAL_COUNTER = new AtomicLong(0L);

    public List<TestClassResult> extractTestResult(PackageTestResult result) {
        if (this.stdoutContains(result, SETUP_FAILED_ERROR)) {
            return this.failResult(result, SETUP_FAILED_ERROR);
        }
        if (this.stdoutContains(result, BUILD_FAILED_ERROR)) {
            return this.failResult(result, BUILD_FAILED_ERROR);
        }
        if (this.stdoutContains(result, CANNOT_LOAD_PACKAGE_ERROR)) {
            return this.failResult(result, CANNOT_LOAD_PACKAGE_ERROR);
        }
        if (this.stdoutContains(result, CANNOT_FIND_PACKAGE_ERROR)) {
            return this.failResult(result, CANNOT_FIND_PACKAGE_ERROR);
        }
        if (this.testFailed(result)) {
            return this.failResult(result, RETURN_NON_ZERO + result.getCode());
        }
        return this.successfulTestResults(result);
    }

    private boolean testFailed(PackageTestResult result) {
        return !this.stdoutContains(result, TEST_START) && result.getCode() != 0;
    }

    private boolean stdoutContains(PackageTestResult result, String error) {
        return result.getStdout().stream().anyMatch(s -> s.contains(error));
    }

    private List<TestClassResult> successfulTestResults(PackageTestResult result) {
        List<String> stdout = this.removeTailMessages(result.getStdout());
        Map<File, String> testFileContents = this.loadTestFiles(result.getTestFiles());
        List<GoTestMethodResult> results = this.extractTestMethodResult(stdout);
        Map<File, List<GoTestMethodResult>> testFileToResults = this.groupByTestFile(results, testFileContents);
        return testFileToResults.entrySet().stream().map(entry -> {
            String className = this.determineClassName(result.getPackagePath(), ((File)entry.getKey()).getName());
            return this.methodResultsToClassResult(className, (List)entry.getValue());
        }).collect(Collectors.toList());
    }

    private List<String> removeTailMessages(List<String> stdout) {
        for (int i = 1; i <= 4 && i <= stdout.size(); ++i) {
            String line = stdout.get(stdout.size() - i).trim();
            if (!"FAIL".equals(line) && !"PASS".equals(line)) continue;
            return stdout.subList(0, stdout.size() - i);
        }
        return stdout;
    }

    private List<TestClassResult> failResult(PackageTestResult testResult, String reason) {
        String message = String.join((CharSequence)"\n", testResult.getStdout());
        GoTestMethodResult ret = new GoTestMethodResult(GLOBAL_COUNTER.incrementAndGet(), reason, TestResult.ResultType.FAILURE, 0L, 0L, message);
        ret.addFailure(message, message, message);
        String className = this.determineClassName(testResult.getPackagePath(), reason);
        return Arrays.asList(this.methodResultsToClassResult(className, Arrays.asList(ret)));
    }

    private List<GoTestMethodResult> extractTestMethodResult(List<String> stdout) {
        List<Pair<Integer, String>> testStartIndicesAndNames = this.extractStartIndiceAndTestMethodNames(stdout);
        ArrayList<GoTestMethodResult> ret = new ArrayList<GoTestMethodResult>();
        for (int i = 0; i < testStartIndicesAndNames.size(); ++i) {
            int currentIndex = (Integer)testStartIndicesAndNames.get(i).getLeft();
            String currentMethodName = (String)testStartIndicesAndNames.get(i).getRight();
            int nextIndex = i == testStartIndicesAndNames.size() - 1 ? stdout.size() : ((Integer)testStartIndicesAndNames.get(i + 1).getLeft()).intValue();
            ret.add(this.extractOneTestMethod(currentMethodName, stdout.subList(currentIndex, nextIndex)));
        }
        return ret;
    }

    private List<Pair<Integer, String>> extractStartIndiceAndTestMethodNames(List<String> stdout) {
        ArrayList<Pair<Integer, String>> ret = new ArrayList<Pair<Integer, String>>();
        for (int i = 0; i < stdout.size(); ++i) {
            Optional<String> testName = this.getRootTestNameFromLine(stdout.get(i));
            if (!testName.isPresent()) continue;
            ret.add((Pair<Integer, String>)Pair.of((Object)i, (Object)testName.get()));
        }
        return ret;
    }

    private Optional<String> getRootTestNameFromLine(String line) {
        if (!(line = line.trim()).startsWith(TEST_START)) {
            return Optional.empty();
        }
        Matcher matcher = TEST_START_LINE_PATTERN.matcher(line);
        if (matcher.find() && "".equals(matcher.group(2))) {
            return Optional.of(matcher.group(1));
        }
        return Optional.empty();
    }

    private GoTestMethodResult extractOneTestMethod(String testMethodName, List<String> resultLines) {
        Pattern testEndLinePattern = Pattern.compile("--- (PASS|FAIL):\\s+" + testMethodName + "\\s+\\(((\\d+)(\\.\\d+)?)s\\)");
        long id = GLOBAL_COUNTER.incrementAndGet();
        String message = String.join((CharSequence)"\n", resultLines);
        for (String line : resultLines) {
            Matcher matcher;
            if (!line.contains(TEST_PASS) && !line.contains(TEST_FAIL) || !(matcher = testEndLinePattern.matcher(line)).find()) continue;
            TestResult.ResultType resultType = RESULT_TYPE_MAP.get(matcher.group(1));
            long duration = DateUtils.toMilliseconds(Double.parseDouble(matcher.group(2)));
            return this.createTestMethodResult(id, testMethodName, resultType, message, duration);
        }
        return this.createTestMethodResult(id, testMethodName, TestResult.ResultType.FAILURE, message, 0L);
    }

    private GoTestMethodResult createTestMethodResult(long id, String methodName, TestResult.ResultType resultType, String message, long duration) {
        GoTestMethodResult result = new GoTestMethodResult(id, methodName, resultType, duration, 0L, message);
        if (TestResult.ResultType.FAILURE == resultType) {
            result.addFailure(message, message, message);
        }
        return result;
    }

    private Map<File, String> loadTestFiles(List<File> testFiles) {
        return testFiles.stream().collect(Collectors.toMap(Function.identity(), IOUtils::toString));
    }

    private TestClassResult methodResultsToClassResult(String className, List<GoTestMethodResult> methodResults) {
        TestClassResult ret = new TestClassResult(GLOBAL_COUNTER.incrementAndGet(), className, 0L);
        methodResults.forEach(arg_0 -> ((TestClassResult)ret).add(arg_0));
        return ret;
    }

    private String determineClassName(String packagePath, String fileName) {
        String escapedPackagePath = IOUtils.encodeInternally(packagePath);
        escapedPackagePath = escapedPackagePath.replaceAll("\\.", "_DOT_");
        return escapedPackagePath.replaceAll("%2F", ".") + "." + fileName.replaceAll("\\.", "_DOT_");
    }

    private Map<File, List<GoTestMethodResult>> groupByTestFile(List<GoTestMethodResult> results, Map<File, String> testFiles) {
        return results.stream().collect(Collectors.groupingBy(result -> this.findTestFileOfMethod(testFiles, result.getName())));
    }

    private File findTestFileOfMethod(Map<File, String> testFileContents, String methodName) {
        LOGGER.debug("trying to find {} in test files.");
        return (File)testFileContents.entrySet().stream().filter(entry -> ((String)entry.getValue()).contains(methodName)).findFirst().get().getKey();
    }

    public static class GoTestMethodResult
    extends TestMethodResult {
        private String message;

        public String getMessage() {
            return this.message;
        }

        public GoTestMethodResult(long id, String name, TestResult.ResultType resultType, long duration, long endTime, String message) {
            super(id, name, resultType, duration, endTime);
            this.message = message;
        }
    }
}

